/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.javadoc.JavadocHelper;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocFixer {
    private final JavadocHelper myHelper = new JavadocHelper();

    public boolean process(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/editorActions/smartEnter/JavadocFixer", "process"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/editorActions/smartEnter/JavadocFixer", "process"));
        }
        CaretModel caretModel = editor.getCaretModel();
        Pair<JavadocHelper.JavadocParameterInfo, List<JavadocHelper.JavadocParameterInfo>> pair = this.myHelper.parse(psiFile, editor, caretModel.getOffset());
        if (pair.first == null) {
            return false;
        }
        JavadocHelper.JavadocParameterInfo next = JavadocFixer.findNext((Collection)pair.second, (JavadocHelper.JavadocParameterInfo)pair.first);
        if (next == null) {
            int line = ((JavadocHelper.JavadocParameterInfo)pair.first).lastLine + 1;
            Document document = editor.getDocument();
            if (line < document.getLineCount()) {
                StringBuilder indent = new StringBuilder();
                boolean insertIndent = true;
                CharSequence text = document.getCharsSequence();
                int max = document.getLineEndOffset(line);
                for (int i = document.getLineStartOffset(line); i < max; ++i) {
                    char c = text.charAt(i);
                    if (c != ' ' && c != '\t') {
                        if (c == '*') {
                            indent.append("* ");
                            if (i < max - 1 && text.charAt(i + 1) != '/') {
                                insertIndent = false;
                            }
                        }
                        indent.append("\n");
                        break;
                    }
                    indent.append(c);
                }
                if (insertIndent) {
                    document.insertString(document.getLineStartOffset(line), (CharSequence)indent);
                }
            }
            JavadocFixer.moveCaretToTheLineEndIfPossible(editor, line);
            return true;
        }
        if (next.parameterDescriptionStartPosition != null) {
            this.myHelper.navigate(next.parameterDescriptionStartPosition, editor, psiFile.getProject());
        } else {
            LogicalPosition position = this.myHelper.calculateDescriptionStartPosition(psiFile, (Collection)pair.second, next);
            this.myHelper.navigate(position, editor, psiFile.getProject());
        }
        return true;
    }

    private static void moveCaretToTheLineEndIfPossible(@NotNull Editor editor, int line) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/editorActions/smartEnter/JavadocFixer", "moveCaretToTheLineEndIfPossible"));
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int offset = line >= document.getLineCount() ? document.getTextLength() : document.getLineEndOffset(line);
        caretModel.moveToOffset(offset);
    }

    @Nullable
    private static JavadocHelper.JavadocParameterInfo findNext(@NotNull Collection<JavadocHelper.JavadocParameterInfo> data, @NotNull JavadocHelper.JavadocParameterInfo anchor) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/editorActions/smartEnter/JavadocFixer", "findNext"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/editorActions/smartEnter/JavadocFixer", "findNext"));
        }
        boolean returnNow = false;
        for (JavadocHelper.JavadocParameterInfo info : data) {
            if (returnNow) {
                return info;
            }
            returnNow = info == anchor;
        }
        return null;
    }
}

