/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiElement psiAtOffset = file.findElementAt(caretOffset);
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            int offset;
            CodeDocumentationAwareCommenter commenter;
            ASTNode token = psiAtOffset.getNode();
            Document document = editor.getDocument();
            String text = document.getText();
            Language language = psiAtOffset.getLanguage();
            Commenter languageCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            CodeDocumentationAwareCommenter codeDocumentationAwareCommenter = commenter = languageCommenter instanceof CodeDocumentationAwareCommenter ? (CodeDocumentationAwareCommenter)languageCommenter : null;
            if (commenter != null && token.getElementType() == commenter.getLineCommentTokenType() && (offset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t")) < document.getTextLength() && text.charAt(offset) != '\n') {
                String prefix = commenter.getLineCommentPrefix();
                assert (prefix != null) : "Line Comment type is set but Line Comment Prefix is null!";
                if (!StringUtil.startsWith((CharSequence)text, (int)offset, (CharSequence)prefix)) {
                    if (text.charAt(caretOffset) != ' ' && !prefix.endsWith(" ")) {
                        prefix = prefix + " ";
                    }
                    document.insertString(caretOffset, (CharSequence)prefix);
                    return EnterHandlerDelegate.Result.Default;
                }
                int afterPrefix = offset + prefix.length();
                if (afterPrefix < document.getTextLength() && text.charAt(afterPrefix) != ' ') {
                    document.insertString(afterPrefix, (CharSequence)" ");
                }
                caretOffsetRef.set((Object)offset);
                return EnterHandlerDelegate.Result.Default;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

