/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlEqTypedHandler
extends TypedHandlerDelegate {
    private List<Caret> caretsForInsertingQuotes = ContainerUtil.newSmartList((Object[])new Object[0]);

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (WebEditorOptions.getInstance().isInsertQuotesForAttributeValue()) {
            boolean inXml;
            boolean bl = inXml = file.getLanguage() instanceof XMLLanguage || file.getViewProvider().getBaseLanguage() instanceof XMLLanguage;
            if (c == '=' && inXml) {
                for (Caret caret : editor.getCaretModel().getAllCarets()) {
                    PsiElement at = file.findElementAt(caret.getOffset() - 1);
                    PsiElement atParent = at != null ? at.getParent() : null;
                    if (!(atParent instanceof XmlAttribute) || ((XmlAttribute)atParent).getValueElement() != null) continue;
                    this.caretsForInsertingQuotes.add(caret);
                }
            }
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/editorActions/XmlEqTypedHandler", "charTyped"));
        }
        for (Caret caret : this.caretsForInsertingQuotes) {
            int offset = caret.getOffset();
            editor.getDocument().insertString(offset, (CharSequence)"\"\"");
            caret.moveToOffset(offset + 1);
        }
        if (editor.getCaretModel().getAllCarets().size() == this.caretsForInsertingQuotes.size()) {
            AutoPopupController.getInstance(project).scheduleAutoPopup(editor);
        }
        this.caretsForInsertingQuotes.clear();
        return super.charTyped(c, project, editor, file);
    }
}

