/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.RenameFileReferenceIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceQuickFixProvider {
    private FileReferenceQuickFixProvider() {
    }

    @NotNull
    public static List<? extends LocalQuickFix> registerQuickFix(FileReference reference) {
        boolean isdirectory;
        PsiFileSystemItem psiElement;
        FileReferenceSet fileReferenceSet = reference.getFileReferenceSet();
        int index = reference.getIndex();
        if (index < 0) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list;
        }
        String newFileName = reference.getFileNameToCreate();
        if (newFileName.isEmpty() || newFileName.indexOf(92) != -1 || newFileName.indexOf(42) != -1 || newFileName.indexOf(63) != -1 || SystemInfo.isWindows && newFileName.indexOf(58) != -1) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list;
        }
        PsiFileSystemItem context = null;
        if (index > 0) {
            context = fileReferenceSet.getReference(index - 1).resolve();
        } else {
            Collection<PsiFileSystemItem> defaultContexts = fileReferenceSet.getDefaultContexts();
            if (defaultContexts.isEmpty()) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list;
            }
            PsiElement element = reference.getElement();
            Module module = element != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)element) : null;
            for (PsiFileSystemItem defaultContext : defaultContexts) {
                VirtualFile virtualFile;
                if (defaultContext == null || (virtualFile = defaultContext.getVirtualFile()) == null || !defaultContext.isDirectory() || !virtualFile.isInLocalFileSystem()) continue;
                if (context == null) {
                    context = defaultContext;
                }
                if (module == null || module != FileReferenceQuickFixProvider.getModuleForContext(defaultContext)) continue;
                context = defaultContext;
                break;
            }
            if (context == null && ApplicationManager.getApplication().isUnitTestMode()) {
                context = defaultContexts.iterator().next();
            }
        }
        if (context == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list;
        }
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list;
        }
        PsiDirectory directory = context.getManager().findDirectory(virtualFile);
        if (directory == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list;
        }
        if (fileReferenceSet.isCaseSensitive() && (psiElement = reference.innerSingleResolve(false)) != null) {
            String existingElementName = ((PsiNamedElement)psiElement).getName();
            RenameFileReferenceIntentionAction renameRefAction = new RenameFileReferenceIntentionAction(existingElementName, reference);
            RenameFileFix renameFileFix = new RenameFileFix(newFileName);
            List<LocalQuickFix> list = Arrays.asList(renameRefAction, renameFileFix);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list;
        }
        if (!reference.isLast()) {
            try {
                directory.checkCreateSubdirectory(newFileName);
            }
            catch (IncorrectOperationException ex) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list;
            }
            isdirectory = true;
        } else {
            FileType ft = FileTypeManager.getInstance().getFileTypeByFileName(newFileName);
            if (ft instanceof UnknownFileType) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list;
            }
            try {
                directory.checkCreateFile(newFileName);
            }
            catch (IncorrectOperationException ex) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list;
            }
            isdirectory = false;
        }
        MyCreateFileFix action = new MyCreateFileFix(isdirectory, newFileName, directory, reference);
        List<CreateFileFix> list = Arrays.asList(new CreateFileFix[]{action});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
        }
        return list;
    }

    @Nullable
    private static Module getModuleForContext(@NotNull PsiFileSystemItem context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "getModuleForContext"));
        }
        VirtualFile file = context.getVirtualFile();
        return file != null ? ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)context.getProject()) : null;
    }

    private static class MyCreateFileFix
    extends CreateFileFix {
        private final boolean isDirectory;
        private final PsiDirectory myDirectory;
        private final FileReference myReference;

        public MyCreateFileFix(boolean isdirectory, String newFileName, PsiDirectory directory, FileReference reference) {
            super(isdirectory, newFileName, directory);
            this.isDirectory = isdirectory;
            this.myDirectory = directory;
            this.myReference = reference;
        }

        @Override
        protected String getFileText() {
            FileTemplate template;
            String templateName;
            if (!this.isDirectory && (templateName = this.myReference.getNewFileTemplateName()) != null && (template = FileTemplateManager.getInstance().getTemplate(templateName)) != null) {
                try {
                    return template.getText(FileTemplateManager.getInstance().getDefaultProperties(this.myDirectory.getProject()));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return super.getFileText();
        }
    }
}

