/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaWithTryCatchSurrounder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SurroundWithTryCatchFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithTryCatchFix");
    private PsiStatement myStatement;

    public SurroundWithTryCatchFix(@NotNull PsiElement element) {
        PsiLambdaExpression lambdaExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "<init>"));
        }
        this.myStatement = null;
        PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodReferenceExpression.class, (boolean)false);
        if (methodReferenceExpression == null && ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class)) == null || lambdaExpression.getBody() instanceof PsiCodeBlock)) {
            this.myStatement = (PsiStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class});
        }
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("surround.with.try.catch.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("surround.with.try.catch.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "isAvailable"));
        }
        return this.myStatement != null && this.myStatement.isValid() && (!(this.myStatement instanceof PsiExpressionStatement) || !RefactoringChangeUtil.isSuperOrThisMethodCall((PsiElement)((PsiExpressionStatement)this.myStatement).getExpression()));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        PsiForStatement forStatement;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line = editor.getCaretModel().getLogicalPosition().line;
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(0, 0));
        if (this.myStatement.getParent() instanceof PsiForStatement && (this.myStatement.equals((forStatement = (PsiForStatement)this.myStatement.getParent()).getInitialization()) || this.myStatement.equals(forStatement.getUpdate()))) {
            this.myStatement = forStatement;
        }
        TextRange range = null;
        try {
            JavaWithTryCatchSurrounder handler = new JavaWithTryCatchSurrounder();
            range = handler.surroundElements(project, editor, new PsiElement[]{this.myStatement});
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        LogicalPosition pos = new LogicalPosition(line, col);
        editor.getCaretModel().moveToLogicalPosition(pos);
        if (range != null) {
            int offset = range.getStartOffset();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

