/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAddAllArrayToCollectionFix
implements IntentionAction {
    private final PsiMethodCallExpression myMethodCall;

    public ReplaceAddAllArrayToCollectionFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAddAllArrayToCollectionFix", "<init>"));
        }
        this.myMethodCall = methodCall;
    }

    @NotNull
    public String getText() {
        String string = "Replace " + this.myMethodCall.getText() + " with " + this.getCollectionsMethodCall();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAddAllArrayToCollectionFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAddAllArrayToCollectionFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAddAllArrayToCollectionFix", "isAvailable"));
        }
        if (!this.myMethodCall.isValid()) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return false;
        }
        Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (jdk == null || !JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_5)) {
            return false;
        }
        PsiReferenceExpression expression = this.myMethodCall.getMethodExpression();
        PsiElement element = expression.resolve();
        if (element instanceof PsiMethod) {
            PsiExpressionList list;
            PsiExpression[] expressions;
            PsiParameter[] psiParameters;
            PsiMethod method = (PsiMethod)element;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass collectionsClass = psiFacade.findClass("java.util.Collection", GlobalSearchScope.allScope((Project)project));
            if (collectionsClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)collectionsClass, (boolean)true) && Comparing.strEqual((String)method.getName(), (String)"addAll") && PsiType.BOOLEAN.equals((Object)method.getReturnType()) && (psiParameters = method.getParameterList().getParameters()).length == 1 && psiParameters[0].getType() instanceof PsiClassType && InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClassType)psiParameters[0].getType()).resolve(), (PsiClass)collectionsClass, (boolean)true) && (expressions = (list = this.myMethodCall.getArgumentList()).getExpressions()).length == 1 && expressions[0].getType() instanceof PsiArrayType) {
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAddAllArrayToCollectionFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression toReplace = elementFactory.createExpressionFromText(this.getCollectionsMethodCall(), (PsiElement)this.myMethodCall);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(this.myMethodCall.replace((PsiElement)toReplace));
    }

    @NonNls
    private String getCollectionsMethodCall() {
        PsiExpression qualifierExpression = this.myMethodCall.getMethodExpression().getQualifierExpression();
        PsiExpression[] expressions = this.myMethodCall.getArgumentList().getExpressions();
        return "java.util.Collections.addAll(" + (qualifierExpression != null ? qualifierExpression.getText() : "this") + ", " + (expressions.length == 0 ? "" : expressions[0].getText()) + ")";
    }

    public boolean startInWriteAction() {
        return true;
    }
}

