/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RenameFileFix
implements IntentionAction,
LocalQuickFix {
    private final String myNewFileName;

    public RenameFileFix(@NotNull String newFileName) {
        if (newFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix", "<init>"));
        }
        this.myNewFileName = newFileName;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"rename.file.fix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.file.fix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix", "applyFix"));
        }
        final PsiFile file = descriptor.getPsiElement().getContainingFile();
        if (this.isAvailable(project, null, file)) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    RenameFileFix.this.invoke(project, null, file);
                }
            }.execute();
        }
    }

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix", "isAvailable"));
        }
        if (file == null || !file.isValid()) {
            return false;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        VirtualFile parent = vFile.getParent();
        if (parent == null) {
            return false;
        }
        VirtualFile newVFile = parent.findChild(this.myNewFileName);
        return newVFile == null || newVFile.equals(vFile);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix", "invoke"));
        }
        VirtualFile vFile = file.getVirtualFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        FileDocumentManager.getInstance().saveDocument(document);
        try {
            vFile.rename((Object)file.getManager(), this.myNewFileName);
        }
        catch (IOException e) {
            MessagesEx.error(project, e.getMessage()).showLater();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

