/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameElementFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix");
    private final PsiNamedElement myElement;
    private final String myNewName;
    private final String myText;

    public RenameElementFix(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        this.myElement = element;
        VirtualFile vFile = this.myElement.getContainingFile().getVirtualFile();
        assert (vFile != null) : element;
        this.myNewName = vFile.getNameWithoutExtension();
        this.myText = CodeInsightBundle.message((String)"rename.public.class.text", (Object[])new Object[]{this.myElement.getName(), this.myNewName});
    }

    public RenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        this.myElement = element;
        this.myNewName = newName;
        this.myText = CodeInsightBundle.message((String)"rename.named.element.text", (Object[])new Object[]{this.myElement.getName(), this.myNewName});
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.element.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "applyFix"));
        }
        final PsiFile file = descriptor.getPsiElement().getContainingFile();
        if (this.isAvailable(project, null, file)) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    RenameElementFix.this.invoke(project, FileEditorManager.getInstance((Project)project).getSelectedTextEditor(), file);
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        if (!this.myElement.isValid()) {
            return false;
        }
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(file.getLanguage());
        return namesValidator != null && namesValidator.isIdentifier(this.myNewName, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        LOG.assertTrue(file == this.myElement.getContainingFile());
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        RenameProcessor processor = new RenameProcessor(project, (PsiElement)this.myElement, this.myNewName, false, false);
        processor.run();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

