/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MakeVarargParameterLastFix
implements IntentionAction {
    private final PsiParameter myParameter;

    public MakeVarargParameterLastFix(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix", "<init>"));
        }
        this.myParameter = parameter;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("make.vararg.parameter.last.text", this.myParameter.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("make.vararg.parameter.last.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix", "isAvailable"));
        }
        return this.myParameter.isValid() && this.myParameter.getManager().isInProject((PsiElement)this.myParameter);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myParameter)) {
            return;
        }
        this.myParameter.getParent().add((PsiElement)this.myParameter);
        this.myParameter.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

