/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class GeneralizeCatchFix
implements IntentionAction {
    private final PsiElement myElement;
    private final PsiClassType myUnhandledException;
    private PsiTryStatement myTryStatement;
    private PsiParameter myCatchParameter;

    public GeneralizeCatchFix(@NotNull PsiElement element, @NotNull PsiClassType unhandledException) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix", "<init>"));
        }
        if (unhandledException == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix", "<init>"));
        }
        this.myElement = element;
        this.myUnhandledException = unhandledException;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("generalize.catch.text", JavaHighlightUtil.formatType(this.myCatchParameter == null ? null : this.myCatchParameter.getType()), JavaHighlightUtil.formatType((PsiType)this.myUnhandledException));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("generalize.catch.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter[] catchBlockParameters;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix", "isAvailable"));
        }
        if (!(this.myElement.isValid() && this.myUnhandledException.isValid() && this.myElement.getManager().isInProject(this.myElement))) {
            return false;
        }
        for (PsiElement element = this.myElement; element != null; element = element.getParent()) {
            if (PsiUtil.isTryBlock((PsiElement)element) || element instanceof PsiResourceList) {
                this.myTryStatement = (PsiTryStatement)element.getParent();
                break;
            }
            if (element instanceof PsiMethod || element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) break;
        }
        if (this.myTryStatement == null) {
            return false;
        }
        for (PsiParameter catchBlockParameter : catchBlockParameters = this.myTryStatement.getCatchBlockParameters()) {
            PsiType type = catchBlockParameter.getType();
            if (!this.myUnhandledException.isAssignableFrom(type)) continue;
            this.myCatchParameter = catchBlockParameter;
            break;
        }
        return this.myCatchParameter != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myElement.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myElement.getProject()).getElementFactory();
        PsiTypeElement type = factory.createTypeElement((PsiType)this.myUnhandledException);
        this.myCatchParameter.getTypeElement().replace((PsiElement)type);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

