/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeleteMultiCatchFix
implements IntentionAction {
    private final PsiTypeElement myTypeElement;

    public DeleteMultiCatchFix(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMultiCatchFix", "<init>"));
        }
        this.myTypeElement = typeElement;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("delete.catch.text", JavaHighlightUtil.formatType(this.myTypeElement.getType()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMultiCatchFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("delete.catch.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMultiCatchFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMultiCatchFix", "isAvailable"));
        }
        return this.myTypeElement.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myTypeElement.getContainingFile());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement last;
        PsiTypeElement first;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMultiCatchFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myTypeElement.getContainingFile())) {
            return;
        }
        PsiElement parentType = this.myTypeElement.getParent();
        if (!(parentType instanceof PsiTypeElement)) {
            return;
        }
        PsiElement right = PsiTreeUtil.skipSiblingsForward((PsiElement)this.myTypeElement, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        if (right instanceof PsiJavaToken && ((PsiJavaToken)right).getTokenType() == JavaTokenType.OR) {
            first = this.myTypeElement;
            last = right;
        } else if (right == null) {
            PsiElement left = PsiTreeUtil.skipSiblingsBackward((PsiElement)this.myTypeElement, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            if (!(left instanceof PsiJavaToken)) {
                return;
            }
            IElementType leftType = ((PsiJavaToken)left).getTokenType();
            if (leftType != JavaTokenType.OR) {
                return;
            }
            first = left;
            last = this.myTypeElement;
        } else {
            return;
        }
        parentType.deleteChildRange((PsiElement)first, last);
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parentType, PsiTypeElement.class);
        if (typeElements.size() == 1) {
            PsiElement parameter = parentType.getParent();
            parameter.addRangeAfter(parentType.getFirstChild(), parentType.getLastChild(), parentType);
            parentType.delete();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

