/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class DeleteMethodBodyFix
implements IntentionAction {
    private final PsiMethod myMethod;

    public DeleteMethodBodyFix(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMethodBodyFix", "<init>"));
        }
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("delete.body.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMethodBodyFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("delete.body.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMethodBodyFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMethodBodyFix", "isAvailable"));
        }
        return this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myMethod.getBody() != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMethodBodyFix", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myMethod)) {
            return;
        }
        PsiCodeBlock body = this.myMethod.getBody();
        assert (body != null);
        body.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

