/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromThisOrSuperFix;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateConstructorFromSuperFix
extends CreateConstructorFromThisOrSuperFix {
    public CreateConstructorFromSuperFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromSuperFix", "<init>"));
        }
        super(methodCall);
    }

    @Override
    protected String getSyntheticMethodName() {
        return "super";
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        PsiClass curClass = (PsiClass)element;
        if (curClass == null || curClass instanceof PsiAnonymousClass) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromSuperFix", "getTargetClasses"));
            }
            return list;
        }
        PsiClassType[] extendsTypes = curClass.getExtendsListTypes();
        if (extendsTypes.length == 0) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromSuperFix", "getTargetClasses"));
            }
            return list;
        }
        PsiClass aClass = extendsTypes[0].resolve();
        if (aClass instanceof PsiTypeParameter) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromSuperFix", "getTargetClasses"));
            }
            return list;
        }
        if (aClass != null && aClass.isValid() && aClass.getManager().isInProject((PsiElement)aClass)) {
            List<PsiClass> list = Collections.singletonList(aClass);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromSuperFix", "getTargetClasses"));
            }
            return list;
        }
        List<PsiClass> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromSuperFix", "getTargetClasses"));
        }
        return list;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.constructor.from.super.call.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromSuperFix", "getFamilyName"));
        }
        return string;
    }
}

