/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeParameterClassFix
extends ExtendsListFix {
    public ChangeParameterClassFix(@NotNull PsiClass aClassToExtend, @NotNull PsiClassType parameterClass) {
        if (aClassToExtend == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "<init>"));
        }
        if (parameterClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "<init>"));
        }
        super(aClassToExtend, parameterClass, true);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.parameter.class.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "isAvailable"));
        }
        return super.isAvailable(project, file, startElement, endElement) && this.myClassToExtendFrom != null && this.myClassToExtendFrom.isValid() && this.myClassToExtendFrom.getQualifiedName() != null;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeParameterClassFix", "invoke"));
        }
        final PsiClass myClass = (PsiClass)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ChangeParameterClassFix.this.invokeImpl(myClass);
            }
        });
        final Editor editor1 = CodeInsightUtil.positionCursor(project, myClass.getContainingFile(), (PsiElement)myClass);
        if (editor1 == null) {
            return;
        }
        final Collection<CandidateInfo> toImplement = OverrideImplementExploreUtil.getMethodsToOverrideImplement(myClass, true);
        if (!toImplement.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        List members = ContainerUtil.map2List((Collection)toImplement, (Function)new Function<CandidateInfo, PsiMethodMember>(){

                            public PsiMethodMember fun(CandidateInfo s) {
                                return new PsiMethodMember(s);
                            }
                        });
                        OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor1, myClass, members, false);
                    }
                });
            } else {
                editor1.getCaretModel().moveToOffset(myClass.getTextRange().getStartOffset());
                OverrideImplementUtil.chooseAndImplementMethods(project, editor1, myClass);
            }
        }
        UndoUtil.markPsiFileForUndo((PsiFile)file);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

