/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddExceptionToCatchFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToCatchFix");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement element = AddExceptionToCatchFix.findElement(file, offset);
        if (element == null) {
            return;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)element.getParent();
        ArrayList<PsiClassType> unhandledExceptions = new ArrayList<PsiClassType>(ExceptionUtil.collectUnhandledExceptions(element, null));
        ExceptionUtil.sortExceptionsByHierarchy(unhandledExceptions);
        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
        PsiCodeBlock catchBlockToSelect = null;
        try {
            if (tryStatement.getFinallyBlock() == null && tryStatement.getCatchBlocks().length == 0) {
                for (PsiClassType unhandledException : unhandledExceptions) {
                    AddExceptionToCatchFix.addCatchStatement(tryStatement, unhandledException, file);
                }
                catchBlockToSelect = tryStatement.getCatchBlocks()[0];
            } else {
                for (PsiClassType unhandledException : unhandledExceptions) {
                    PsiCodeBlock codeBlock = AddExceptionToCatchFix.addCatchStatement(tryStatement, unhandledException, file);
                    if (catchBlockToSelect != null) continue;
                    catchBlockToSelect = codeBlock;
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        if (catchBlockToSelect != null) {
            TextRange range = SurroundWithUtil.getRangeToSelect(catchBlockToSelect);
            editor.getCaretModel().moveToOffset(range.getStartOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private static PsiCodeBlock addCatchStatement(PsiTryStatement tryStatement, PsiClassType exceptionType, PsiFile file) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)tryStatement.getProject()).getElementFactory();
        if (tryStatement.getTryBlock() == null) {
            AddExceptionToCatchFix.addTryBlock(tryStatement, factory);
        }
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)tryStatement.getProject());
        String name = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)exceptionType).names[0];
        name = styleManager.suggestUniqueVariableName(name, (PsiElement)tryStatement, false);
        PsiCatchSection catchSection = factory.createCatchSection((PsiType)exceptionType, name, (PsiElement)file);
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            tryStatement.add((PsiElement)catchSection);
        } else {
            tryStatement.addBefore((PsiElement)catchSection, AddExceptionToCatchFix.getFinallySectionStart(finallyBlock));
        }
        PsiParameter[] parameters = tryStatement.getCatchBlockParameters();
        PsiTypeElement typeElement = parameters[parameters.length - 1].getTypeElement();
        if (typeElement != null) {
            JavaCodeStyleManager.getInstance((Project)file.getProject()).shortenClassReferences((PsiElement)typeElement);
        }
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        return catchBlocks[catchBlocks.length - 1];
    }

    private static void addTryBlock(PsiTryStatement tryStatement, PsiElementFactory factory) {
        PsiCatchSection anchor;
        PsiCodeBlock tryBlock = factory.createCodeBlock();
        PsiCatchSection[] catchSections = tryStatement.getCatchSections();
        if (catchSections.length > 0) {
            anchor = catchSections[0];
        } else {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            PsiElement psiElement = anchor = finallyBlock != null ? AddExceptionToCatchFix.getFinallySectionStart(finallyBlock) : null;
        }
        if (anchor != null) {
            tryStatement.addBefore((PsiElement)tryBlock, (PsiElement)anchor);
        } else {
            tryStatement.add((PsiElement)tryBlock);
        }
    }

    private static PsiElement getFinallySectionStart(@NotNull PsiCodeBlock finallyBlock) {
        PsiCodeBlock finallyElement;
        if (finallyBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix", "getFinallySectionStart"));
        }
        for (finallyElement = finallyBlock; !PsiUtil.isJavaToken((PsiElement)finallyElement, (IElementType)JavaTokenType.FINALLY_KEYWORD) && finallyElement != null; finallyElement = finallyElement.getPrevSibling()) {
        }
        assert (finallyElement != null) : finallyBlock.getParent().getText();
        return finallyElement;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix", "isAvailable"));
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = AddExceptionToCatchFix.findElement(file, offset);
        if (element == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("add.catch.clause.text", new Object[0]));
        return true;
    }

    @Nullable
    private static PsiElement findElement(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            element = file.findElementAt(offset - 1);
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiTryStatement.class, PsiMethod.class});
        if (parent == null || parent instanceof PsiMethod) {
            return null;
        }
        PsiTryStatement statement = (PsiTryStatement)parent;
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null && tryBlock.getTextRange().contains(offset) && !ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, statement.getParent()).isEmpty()) {
            return tryBlock;
        }
        PsiResourceList resourceList = statement.getResourceList();
        if (resourceList != null && resourceList.getTextRange().contains(offset) && !ExceptionUtil.collectUnhandledExceptions((PsiElement)resourceList, statement.getParent()).isEmpty()) {
            return resourceList;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.catch.clause.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix", "getFamilyName"));
        }
        return string;
    }
}

