/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlPathReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/XmlPathReferenceInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)value, holder, isOnTheFly);
            }

            public void visitXmlDoctype(XmlDoctype xmlDoctype) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)xmlDoctype, holder, isOnTheFly);
            }

            public void visitXmlTag(XmlTag tag) {
                XmlPathReferenceInspection.this.checkRefs((PsiElement)tag, holder, isOnTheFly);
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlPathReferenceInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private void checkRefs(PsiElement element, ProblemsHolder holder, boolean isOnTheFly) {
        PsiReference[] references;
        for (PsiReference reference : references = element.getReferences()) {
            boolean isHtml;
            if (!XmlHighlightVisitor.isUrlReference(reference) || !this.needToCheckRef(reference) || (isHtml = HtmlUtil.isHtmlTagContainingFile(element)) ^ this.isForHtml() || !isHtml && XmlHighlightVisitor.skipValidation(element) || !XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
            holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), isHtml ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    protected boolean needToCheckRef(PsiReference reference) {
        return true;
    }

    protected boolean isForHtml() {
        return false;
    }
}

