/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="HighlightingSettingsPerFile", storages={@Storage(file="$WORKSPACE_FILE$")})
public class HighlightingSettingsPerFile
extends HighlightingLevelManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String SETTING_TAG = "setting";
    @NonNls
    private static final String ROOT_ATT_PREFIX = "root";
    @NonNls
    private static final String FILE_ATT = "file";
    private final Map<VirtualFile, FileHighlightingSetting[]> myHighlightSettings = new HashMap<VirtualFile, FileHighlightingSetting[]>();

    public static HighlightingSettingsPerFile getInstance(Project project) {
        return (HighlightingSettingsPerFile)ServiceManager.getService((Project)project, HighlightingLevelManager.class);
    }

    @NotNull
    public FileHighlightingSetting getHighlightingSettingForRoot(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "getHighlightingSettingForRoot"));
        }
        PsiFile containingFile = root.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        FileHighlightingSetting[] fileHighlightingSettings = this.myHighlightSettings.get(virtualFile);
        int index = PsiUtilBase.getRootIndex((PsiElement)root);
        if (fileHighlightingSettings == null || fileHighlightingSettings.length <= index) {
            FileHighlightingSetting fileHighlightingSetting = HighlightingSettingsPerFile.getDefaultHighlightingSetting(root.getProject(), virtualFile);
            if (fileHighlightingSetting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "getHighlightingSettingForRoot"));
            }
            return fileHighlightingSetting;
        }
        FileHighlightingSetting fileHighlightingSetting = fileHighlightingSettings[index];
        if (fileHighlightingSetting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "getHighlightingSettingForRoot"));
        }
        return fileHighlightingSetting;
    }

    @NotNull
    private static FileHighlightingSetting getDefaultHighlightingSetting(@NotNull Project project, VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "getDefaultHighlightingSetting"));
        }
        if (virtualFile != null) {
            DefaultHighlightingSettingProvider[] providers = (DefaultHighlightingSettingProvider[])DefaultHighlightingSettingProvider.EP_NAME.getExtensions();
            List filtered = DumbService.getInstance((Project)project).filterByDumbAwareness(Arrays.asList(providers));
            for (DefaultHighlightingSettingProvider p : filtered) {
                FileHighlightingSetting setting = p.getDefaultSetting(project, virtualFile);
                if (setting == null) continue;
                FileHighlightingSetting fileHighlightingSetting = setting;
                if (fileHighlightingSetting == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "getDefaultHighlightingSetting"));
                }
                return fileHighlightingSetting;
            }
        }
        FileHighlightingSetting fileHighlightingSetting = FileHighlightingSetting.FORCE_HIGHLIGHTING;
        if (fileHighlightingSetting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "getDefaultHighlightingSetting"));
        }
        return fileHighlightingSetting;
    }

    @NotNull
    private static FileHighlightingSetting[] getDefaults(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "getDefaults"));
        }
        int rootsCount = file.getViewProvider().getLanguages().size();
        FileHighlightingSetting[] fileHighlightingSettings = new FileHighlightingSetting[rootsCount];
        for (int i = 0; i < fileHighlightingSettings.length; ++i) {
            fileHighlightingSettings[i] = FileHighlightingSetting.FORCE_HIGHLIGHTING;
        }
        if (fileHighlightingSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "getDefaults"));
        }
        return fileHighlightingSettings;
    }

    public void setHighlightingSettingForRoot(@NotNull PsiElement root, @NotNull FileHighlightingSetting setting) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "setHighlightingSettingForRoot"));
        }
        if (setting == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "setHighlightingSettingForRoot"));
        }
        PsiFile containingFile = root.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        FileHighlightingSetting[] defaults = this.myHighlightSettings.get(virtualFile);
        int rootIndex = PsiUtilBase.getRootIndex((PsiElement)root);
        if (defaults != null && rootIndex >= defaults.length) {
            defaults = null;
        }
        if (defaults == null) {
            defaults = HighlightingSettingsPerFile.getDefaults(containingFile);
        }
        defaults[rootIndex] = setting;
        boolean toRemove = true;
        for (FileHighlightingSetting aDefault : defaults) {
            if (aDefault == FileHighlightingSetting.NONE) continue;
            toRemove = false;
        }
        if (toRemove) {
            this.myHighlightSettings.remove(virtualFile);
        } else {
            this.myHighlightSettings.put(virtualFile, defaults);
        }
    }

    public void loadState(Element element) {
        List children = element.getChildren(SETTING_TAG);
        for (Object aChildren : children) {
            VirtualFile fileByUrl;
            Element child = (Element)aChildren;
            String url = child.getAttributeValue(FILE_ATT);
            if (url == null || (fileByUrl = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
            ArrayList<FileHighlightingSetting> settings = new ArrayList<FileHighlightingSetting>();
            int index = 0;
            while (child.getAttributeValue(ROOT_ATT_PREFIX + index) != null) {
                String attributeValue = child.getAttributeValue(ROOT_ATT_PREFIX + index++);
                settings.add(Enum.valueOf(FileHighlightingSetting.class, attributeValue));
            }
            this.myHighlightSettings.put(fileByUrl, settings.toArray(new FileHighlightingSetting[settings.size()]));
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<VirtualFile, FileHighlightingSetting[]> entry : this.myHighlightSettings.entrySet()) {
            Element child = new Element(SETTING_TAG);
            VirtualFile vFile = entry.getKey();
            if (!vFile.isValid()) continue;
            child.setAttribute(FILE_ATT, vFile.getUrl());
            for (int i = 0; i < entry.getValue().length; ++i) {
                FileHighlightingSetting fileHighlightingSetting = entry.getValue()[i];
                child.setAttribute(ROOT_ATT_PREFIX + i, fileHighlightingSetting.toString());
            }
            element.addContent(child);
        }
        return element;
    }

    @Override
    public boolean shouldHighlight(@NotNull PsiElement psiRoot) {
        if (psiRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "shouldHighlight"));
        }
        FileHighlightingSetting settingForRoot = this.getHighlightingSettingForRoot(psiRoot);
        return settingForRoot != FileHighlightingSetting.SKIP_HIGHLIGHTING;
    }

    @Override
    public boolean shouldInspect(@NotNull PsiElement psiRoot) {
        if (psiRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile", "shouldInspect"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!this.shouldHighlight(psiRoot)) {
            return false;
        }
        Project project = psiRoot.getProject();
        VirtualFile virtualFile = psiRoot.getContainingFile().getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return false;
        }
        if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (ProjectScope.getLibrariesScope((Project)project).contains(virtualFile) && !fileIndex.isInContent(virtualFile)) {
            return false;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile)) {
            return false;
        }
        FileHighlightingSetting settingForRoot = this.getHighlightingSettingForRoot(psiRoot);
        return settingForRoot != FileHighlightingSetting.SKIP_INSPECTION;
    }
}

