/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SuppressWarningsFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/SuppressWarningsFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/actions/SuppressWarningsFoldingBuilder", "buildFoldRegions"));
        }
        if (!(root instanceof PsiJavaFile) || quick || !JavaCodeFoldingSettings.getInstance().isCollapseSuppressWarnings()) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/SuppressWarningsFoldingBuilder", "buildFoldRegions"));
            }
            return FoldingDescriptor.EMPTY;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)root)) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/SuppressWarningsFoldingBuilder", "buildFoldRegions"));
            }
            return FoldingDescriptor.EMPTY;
        }
        final ArrayList result = new ArrayList();
        root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                if (Comparing.strEqual((String)annotation.getQualifiedName(), (String)SuppressWarnings.class.getName())) {
                    result.add(new FoldingDescriptor((PsiElement)annotation, annotation.getTextRange()));
                }
                super.visitAnnotation(annotation);
            }
        });
        FoldingDescriptor[] foldingDescriptorArray = result.toArray(new FoldingDescriptor[result.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/SuppressWarningsFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/SuppressWarningsFoldingBuilder", "getPlaceholderText"));
        }
        PsiElement element = node.getPsi();
        if (element instanceof PsiAnnotation) {
            return "/" + StringUtil.join((Object[])((PsiAnnotation)element).getParameterList().getAttributes(), (Function)new Function<PsiNameValuePair, String>(){

                public String fun(PsiNameValuePair value) {
                    return SuppressWarningsFoldingBuilder.getMemberValueText(value.getValue());
                }
            }, (String)", ") + "/";
        }
        return element.getText();
    }

    private static String getMemberValueText(PsiAnnotationMemberValue memberValue) {
        Object o;
        if (memberValue instanceof PsiArrayInitializerMemberValue) {
            Object[] initializers = ((PsiArrayInitializerMemberValue)memberValue).getInitializers();
            return StringUtil.join((Object[])initializers, (Function)new Function<PsiAnnotationMemberValue, String>(){

                public String fun(PsiAnnotationMemberValue psiAnnotationMemberValue) {
                    return SuppressWarningsFoldingBuilder.getMemberValueText(psiAnnotationMemberValue);
                }
            }, (String)", ");
        }
        if (memberValue instanceof PsiLiteral && (o = ((PsiLiteral)memberValue).getValue()) != null) {
            return o.toString();
        }
        return memberValue != null ? memberValue.getText() : "";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/SuppressWarningsFoldingBuilder", "isCollapsedByDefault"));
        }
        return JavaCodeFoldingSettings.getInstance().isCollapseSuppressWarnings();
    }
}

