/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressByJavaCommentFix
extends SuppressByCommentFix {
    public SuppressByJavaCommentFix(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/SuppressByJavaCommentFix", "<init>"));
        }
        super(key, PsiStatement.class);
    }

    @Override
    @Nullable
    public PsiElement getContainer(PsiElement context) {
        if (SuppressByJavaCommentFix.hasJspMethodCallAsParent(context)) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class, (boolean)false);
    }

    private static boolean hasJspMethodCallAsParent(PsiElement context) {
        PsiMethod method;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class)) != null) {
            if (method instanceof SyntheticElement) {
                return true;
            }
            context = method;
        }
        return false;
    }

    @Override
    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/SuppressByJavaCommentFix", "createSuppression"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/actions/SuppressByJavaCommentFix", "createSuppression"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/actions/SuppressByJavaCommentFix", "createSuppression"));
        }
        PsiElement declaredElement = JavaSuppressionUtil.getElementToAnnotate(element, container);
        if (declaredElement == null) {
            this.suppressWithComment(project, element, container);
        } else {
            JavaSuppressionUtil.addSuppressAnnotation(project, container, (PsiModifierListOwner)((PsiLocalVariable)declaredElement), this.myID);
        }
    }

    protected void suppressWithComment(Project project, PsiElement element, PsiElement container) {
        super.createSuppression(project, element, container);
    }
}

