/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Alarm;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class StatusBarUpdater
implements Disposable {
    private final Project myProject;
    private final DumbAwareRunnable myUpdateStatusRunnable = new DumbAwareRunnable(){

        public void run() {
            if (!StatusBarUpdater.this.myProject.isDisposed()) {
                StatusBarUpdater.this.updateStatus();
            }
        }
    };
    private final Alarm updateStatusAlarm = new Alarm();

    public StatusBarUpdater(Project project) {
        this.myProject = project;
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/StatusBarUpdater$2", "selectionChanged"));
                }
                StatusBarUpdater.this.updateLater();
            }
        });
        project.getMessageBus().connect((Disposable)this).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListenerAdapter(){

            public void daemonFinished() {
                StatusBarUpdater.this.updateLater();
            }
        });
    }

    private void updateLater() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            this.myUpdateStatusRunnable.run();
        } else {
            this.updateStatusAlarm.cancelAllRequests();
            this.updateStatusAlarm.addRequest((Runnable)this.myUpdateStatusRunnable, 100);
        }
    }

    public void dispose() {
    }

    private void updateStatus() {
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor == null || !editor.getContentComponent().hasFocus()) {
            return;
        }
        Document document = editor.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        HighlightInfo info = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(document, offset, false, HighlightSeverity.WARNING);
        String text = info != null && info.getDescription() != null ? info.getDescription() : "";
        StatusBar statusBar = WindowManager.getInstance().getStatusBar((Component)editor.getContentComponent(), this.myProject);
        if (statusBar != null && !text.equals(statusBar.getInfo())) {
            statusBar.setInfo(text, "updater");
        }
    }
}

