/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FunctionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RecursiveCallLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/RecursiveCallLineMarkerProvider", "getLineMarkerInfo"));
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/RecursiveCallLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/RecursiveCallLineMarkerProvider", "collectSlowLineMarkers"));
        }
        HashSet<PsiStatement> statements = new HashSet<PsiStatement>();
        for (PsiElement element : elements) {
            PsiMethodCallExpression methodCall;
            PsiStatement statement;
            ProgressManager.checkCanceled();
            if (!(element instanceof PsiMethodCallExpression) || statements.contains(statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)(methodCall = (PsiMethodCallExpression)element), PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class})) || !RecursiveCallLineMarkerProvider.isRecursiveMethodCall(methodCall)) continue;
            statements.add(statement);
            result.add(new RecursiveMethodCallMarkerInfo(methodCall));
        }
    }

    public static boolean isRecursiveMethodCall(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/RecursiveCallLineMarkerProvider", "isRecursiveMethodCall"));
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
        if (method == null || !method.getName().equals(methodCall.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiMethod resolvedMethod = methodCall.resolveMethod();
        if (!Comparing.equal((Object)method, (Object)resolvedMethod)) {
            return false;
        }
        PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
        return qualifier == null || qualifier instanceof PsiThisExpression;
    }

    private static class RecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiMethodCallExpression> {
        private RecursiveMethodCallMarkerInfo(@NotNull PsiMethodCallExpression methodCall) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/RecursiveCallLineMarkerProvider$RecursiveMethodCallMarkerInfo", "<init>"));
            }
            super((PsiElement)methodCall, methodCall.getTextRange(), AllIcons.Gutter.RecursiveMethod, 6, FunctionUtil.constant((Object)"Recursive call"), null, GutterIconRenderer.Alignment.RIGHT);
        }

        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiMethodCallExpression>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }
    }
}

