/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.PostHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.util.containers.Predicate;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostHighlightingPassFactory
extends AbstractProjectComponent
implements MainHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PostHighlightingPassFactory");

    public PostHighlightingPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar, HighlightVisitorImpl hvi) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, true, 5);
        if (hvi == null) {
            HighlightVisitor[] extensions = (HighlightVisitor[])Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject);
            LOG.error("com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl is unregistered; all available highlight visitors are: " + Arrays.asList(extensions));
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("PostHighlightingPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "getComponentName"));
        }
        return "PostHighlightingPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "createHighlightingPass"));
        }
        TextRange textRange = FileStatusMap.getDirtyTextRange(editor, 4);
        if (textRange == null && PostHighlightingPass.isUpToDate(file)) {
            return null;
        }
        return this.create(file, editor.getDocument(), editor, new DefaultHighlightInfoProcessor());
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "createMainHighlightingPass"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "createMainHighlightingPass"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "createMainHighlightingPass"));
        }
        return this.create(file, document, null, highlightInfoProcessor);
    }

    private PostHighlightingPass create(final @NotNull PsiFile file, @NotNull Document document, Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "create"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "create"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/PostHighlightingPassFactory", "create"));
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(file.getProject()).getInspectionProfile();
        final UnusedDeclarationInspection myDeadCodeInspection = (UnusedDeclarationInspection)profile.getUnwrappedTool("UnusedDeclaration", (PsiElement)file);
        HighlightDisplayKey myDeadCodeKey = HighlightDisplayKey.find((String)"UnusedDeclaration");
        final boolean myDeadCodeEnabled = profile.isToolEnabled(myDeadCodeKey, (PsiElement)file);
        return new PostHighlightingPass(this.myProject, file, editor, document, highlightInfoProcessor, (Predicate)new Predicate<PsiElement>(){

            public boolean apply(PsiElement member) {
                return !myDeadCodeEnabled || myDeadCodeInspection.isEntryPoint(member);
            }
        }){

            @Override
            protected boolean isUnusedImportEnabled(HighlightDisplayKey unusedImportKey) {
                return super.isUnusedImportEnabled(unusedImportKey) && PostHighlightingPassFactory.isUnusedImportEnabled((PsiElement)file);
            }
        };
    }

    private static boolean isUnusedImportEnabled(PsiElement file) {
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        return jspFile == null || !JspSpiUtil.isIncludedOrIncludesSomething(jspFile);
    }
}

