/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PassExecutorService
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PassExecutorService");
    private final Map<ScheduledPass, Job<Void>> mySubmittedPasses = new ConcurrentHashMap<ScheduledPass, Job<Void>>();
    private final Project myProject;
    private volatile boolean isDisposed;
    private final AtomicInteger nextPassId = new AtomicInteger(100);
    private static final ConcurrentHashMap<Thread, Integer> threads = new ConcurrentHashMap();
    private static final Key<Throwable> THROWABLE_KEY = Key.create((String)"THROWABLE_KEY");

    public PassExecutorService(Project project) {
        this.myProject = project;
    }

    public void dispose() {
        this.cancelAll(true);
        this.isDisposed = true;
    }

    public void cancelAll(boolean waitForTermination) {
        for (Job<Void> submittedPass : this.mySubmittedPasses.values()) {
            submittedPass.cancel();
        }
        if (waitForTermination) {
            try {
                while (!this.waitFor(50)) {
                    boolean i = false;
                }
            }
            catch (ProcessCanceledException ignored) {
            }
            catch (Throwable throwable) {
                LOG.error(throwable);
            }
        }
        this.mySubmittedPasses.clear();
    }

    public void submitPasses(@NotNull Map<FileEditor, HighlightingPass[]> passesMap, @NotNull DaemonProgressIndicator updateProgress, int jobPriority) {
        if (passesMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "submitPasses"));
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "submitPasses"));
        }
        if (this.isDisposed()) {
            return;
        }
        int id = 1;
        THashMap toBeSubmitted = new THashMap(passesMap.size());
        HashMap<Document, List> documentToEditors = new HashMap<Document, List>();
        HashMap<FileEditor, List> textPasses = new HashMap<FileEditor, List>(passesMap.size());
        for (Map.Entry<FileEditor, HighlightingPass[]> entry : passesMap.entrySet()) {
            FileEditor fileEditor = entry.getKey();
            HighlightingPass[] passes = entry.getValue();
            Document document = null;
            if (fileEditor instanceof TextEditor) {
                Editor editor = ((TextEditor)fileEditor).getEditor();
                LOG.assertTrue(!(editor instanceof EditorWindow));
                document = editor.getDocument();
            }
            for (int i = 0; i < passes.length; ++i) {
                TextEditorHighlightingPass textEditorHighlightingPass;
                final HighlightingPass pass = passes[i];
                if (pass instanceof TextEditorHighlightingPass) {
                    textEditorHighlightingPass = (TextEditorHighlightingPass)pass;
                } else {
                    textEditorHighlightingPass = new TextEditorHighlightingPass(this.myProject, document, true){

                        @Override
                        public void doCollectInformation(@NotNull ProgressIndicator progress) {
                            if (progress == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PassExecutorService$1", "doCollectInformation"));
                            }
                            pass.collectInformation(progress);
                        }

                        @Override
                        public void doApplyInformationToEditor() {
                            pass.applyInformationToEditor();
                        }
                    };
                    textEditorHighlightingPass.setId(id++);
                    if (i > 0) {
                        textEditorHighlightingPass.setCompletionPredecessorIds(new int[]{i - 1});
                    }
                }
                document = textEditorHighlightingPass.getDocument();
                List textPassesForDocument = (List)textPasses.get(fileEditor);
                if (textPassesForDocument == null) {
                    textPassesForDocument = new SmartList();
                    textPasses.put(fileEditor, textPassesForDocument);
                }
                textPassesForDocument.add(textEditorHighlightingPass);
                List editors = (List)documentToEditors.get(document);
                if (editors == null) {
                    editors = new SmartList();
                    documentToEditors.put(document, editors);
                }
                if (editors.contains(fileEditor)) continue;
                editors.add(fileEditor);
            }
        }
        ArrayList<ScheduledPass> freePasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 5);
        ArrayList<ScheduledPass> dependentPasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 10);
        AtomicInteger threadsToStartCountdown = new AtomicInteger(0);
        for (Map.Entry entry : documentToEditors.entrySet()) {
            List fileEditors = (List)entry.getValue();
            List passes = (List)textPasses.get(this.getPreferredFileEditor((Document)entry.getKey(), fileEditors));
            if (passes == null) continue;
            threadsToStartCountdown.addAndGet(passes.size());
            ContainerUtil.quickSort((List)passes, (Comparator)new Comparator<TextEditorHighlightingPass>(){

                @Override
                public int compare(TextEditorHighlightingPass o1, TextEditorHighlightingPass o2) {
                    return o1.getId() - o2.getId();
                }
            });
            int passId = -1;
            TextEditorHighlightingPass currentPass = null;
            for (int i = 0; i <= passes.size(); ++i) {
                int newId = -1;
                if (i < passes.size()) {
                    currentPass = (TextEditorHighlightingPass)passes.get(i);
                    newId = currentPass.getId();
                }
                if (newId == passId) continue;
                this.createScheduledPass(fileEditors, currentPass, (Map<Pair<Document, Integer>, ScheduledPass>)toBeSubmitted, passes, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, jobPriority);
                passId = newId;
            }
        }
        PassExecutorService.log(updateProgress, null, "---------------------starting------------------------ " + threadsToStartCountdown.get(), freePasses);
        for (ScheduledPass dependentPass : dependentPasses) {
            this.mySubmittedPasses.put(dependentPass, (Job<Void>)Job.NULL_JOB);
        }
        for (ScheduledPass freePass : freePasses) {
            this.submit(freePass);
        }
    }

    @Nullable
    private FileEditor getPreferredFileEditor(Document document, @NotNull List<FileEditor> fileEditors) {
        FileEditor selected;
        VirtualFile file;
        if (fileEditors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "getPreferredFileEditor"));
        }
        if (document != null && (file = FileDocumentManager.getInstance().getFile(document)) != null && fileEditors.contains(selected = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file))) {
            return selected;
        }
        if (!fileEditors.isEmpty()) {
            return fileEditors.get(0);
        }
        return null;
    }

    @NotNull
    private ScheduledPass createScheduledPass(@NotNull List<FileEditor> fileEditors, @NotNull TextEditorHighlightingPass pass, @NotNull Map<Pair<Document, Integer>, ScheduledPass> toBeSubmitted, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown, int jobPriority) {
        ScheduledPass predecessor;
        if (fileEditors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (toBeSubmitted == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (textEditorHighlightingPasses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (freePasses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (dependentPasses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (threadsToStartCountdown == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        int passId = pass.getId();
        Document document = pass.getDocument();
        Pair key = Pair.create((Object)document, (Object)passId);
        ScheduledPass scheduledPass = toBeSubmitted.get(key);
        if (scheduledPass != null) {
            ScheduledPass scheduledPass2 = scheduledPass;
            if (scheduledPass2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
            }
            return scheduledPass2;
        }
        scheduledPass = new ScheduledPass(fileEditors, pass, updateProgress, threadsToStartCountdown, jobPriority);
        toBeSubmitted.put((Pair<Document, Integer>)key, scheduledPass);
        for (int predecessorId : pass.getCompletionPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditors, document, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, jobPriority, predecessorId);
            if (predecessor == null) continue;
            predecessor.mySuccessorsOnCompletion.add(scheduledPass);
            scheduledPass.myRunningPredecessorsCount.incrementAndGet();
        }
        for (int predecessorId : pass.getStartingPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditors, document, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, jobPriority, predecessorId);
            if (predecessor == null) continue;
            predecessor.mySuccessorsOnSubmit.add(scheduledPass);
            scheduledPass.myRunningPredecessorsCount.incrementAndGet();
        }
        if (scheduledPass.myRunningPredecessorsCount.get() == 0 && !freePasses.contains(scheduledPass)) {
            freePasses.add(scheduledPass);
        } else if (!dependentPasses.contains(scheduledPass)) {
            dependentPasses.add(scheduledPass);
        }
        ScheduledPass scheduledPass3 = scheduledPass;
        if (scheduledPass3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        return scheduledPass3;
    }

    private ScheduledPass findOrCreatePredecessorPass(@NotNull List<FileEditor> fileEditors, Document document, @NotNull Map<Pair<Document, Integer>, ScheduledPass> toBeSubmitted, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger myThreadsToStartCountdown, int jobPriority, int predecessorId) {
        if (fileEditors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (toBeSubmitted == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (textEditorHighlightingPasses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (freePasses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (dependentPasses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (myThreadsToStartCountdown == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        Pair predKey = Pair.create((Object)document, (Object)predecessorId);
        ScheduledPass predecessor = toBeSubmitted.get(predKey);
        if (predecessor == null) {
            TextEditorHighlightingPass textEditorPass = PassExecutorService.findPassById(predecessorId, textEditorHighlightingPasses);
            predecessor = textEditorPass == null ? null : this.createScheduledPass(fileEditors, textEditorPass, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, myThreadsToStartCountdown, jobPriority);
        }
        return predecessor;
    }

    private static TextEditorHighlightingPass findPassById(int id, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses) {
        if (textEditorHighlightingPasses == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findPassById"));
        }
        TextEditorHighlightingPass textEditorPass = null;
        for (TextEditorHighlightingPass found : textEditorHighlightingPasses) {
            if (found.getId() != id) continue;
            textEditorPass = found;
            break;
        }
        return textEditorPass;
    }

    private void submit(@NotNull ScheduledPass pass) {
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "submit"));
        }
        if (!pass.myUpdateProgress.isCanceled()) {
            Job<Void> job = JobLauncher.getInstance().submitToJobThread(pass.myJobPriority, pass, new Consumer<Future>(){

                public void consume(Future future) {
                    try {
                        if (!future.isCancelled()) {
                            future.get();
                        }
                    }
                    catch (CancellationException ignored) {
                    }
                    catch (InterruptedException ignored) {
                    }
                    catch (ExecutionException e) {
                        LOG.error(e.getCause());
                    }
                }
            });
            this.mySubmittedPasses.put(pass, job);
        }
    }

    private void applyInformationToEditorsLater(final @NotNull List<FileEditor> fileEditors, final @NotNull TextEditorHighlightingPass pass, final @NotNull DaemonProgressIndicator updateProgress, final @NotNull AtomicInteger threadsToStartCountdown) {
        if (fileEditors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "applyInformationToEditorsLater"));
        }
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "applyInformationToEditorsLater"));
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "applyInformationToEditorsLater"));
        }
        if (threadsToStartCountdown == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "applyInformationToEditorsLater"));
        }
        final boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

            public void run() {
                PassExecutorService.this.doApplyInformationToEditors(updateProgress, pass, fileEditors, threadsToStartCountdown, testMode);
            }
        }, ModalityState.stateForComponent((Component)fileEditors.get(0).getComponent()));
    }

    private void doApplyInformationToEditors(@NotNull DaemonProgressIndicator updateProgress, @NotNull TextEditorHighlightingPass pass, @NotNull List<FileEditor> fileEditors, @NotNull AtomicInteger threadsToStartCountdown, boolean testMode) {
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "doApplyInformationToEditors"));
        }
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "doApplyInformationToEditors"));
        }
        if (fileEditors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "doApplyInformationToEditors"));
        }
        if (threadsToStartCountdown == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "doApplyInformationToEditors"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed() || this.myProject.isDisposed()) {
            updateProgress.cancel();
        }
        if (updateProgress.isCanceled()) {
            PassExecutorService.log(updateProgress, pass, " is canceled during apply, sorry");
            return;
        }
        boolean applied = false;
        for (FileEditor fileEditor : fileEditors) {
            LOG.assertTrue(fileEditor != null);
            try {
                if (!testMode && !fileEditor.getComponent().isDisplayable()) continue;
                if (!applied) {
                    applied = true;
                    PassExecutorService.log(updateProgress, pass, " Applied");
                    pass.applyInformationToEditor();
                }
                this.afterApplyInformationToEditor(pass, fileEditor, updateProgress);
                if (!pass.isRunIntentionPassAfter() || !(fileEditor instanceof TextEditor) || updateProgress.isCanceled()) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                ShowIntentionsPass ip = new ShowIntentionsPass(this.myProject, editor, -1);
                ip.setId(this.nextPassId.incrementAndGet());
                threadsToStartCountdown.incrementAndGet();
                this.submit(new ScheduledPass(fileEditors, ip, updateProgress, threadsToStartCountdown, 100));
            }
            catch (RuntimeException e) {
                PassExecutorService.log(updateProgress, pass, "Error " + e);
                throw e;
            }
        }
        if (threadsToStartCountdown.decrementAndGet() == 0) {
            PassExecutorService.log(updateProgress, pass, "Stopping ");
            updateProgress.stopIfRunning();
        } else {
            PassExecutorService.log(updateProgress, pass, "Finished but there are passes in the queue: " + threadsToStartCountdown.get());
        }
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    protected abstract void afterApplyInformationToEditor(TextEditorHighlightingPass var1, FileEditor var2, ProgressIndicator var3);

    @NotNull
    public List<TextEditorHighlightingPass> getAllSubmittedPasses() {
        ArrayList<TextEditorHighlightingPass> result = new ArrayList<TextEditorHighlightingPass>(this.mySubmittedPasses.size());
        for (ScheduledPass scheduledPass : this.mySubmittedPasses.keySet()) {
            if (scheduledPass.myUpdateProgress.isCanceled()) continue;
            result.add(scheduledPass.myPass);
        }
        ContainerUtil.quickSort(result, (Comparator)new Comparator<TextEditorHighlightingPass>(){

            @Override
            public int compare(TextEditorHighlightingPass o1, TextEditorHighlightingPass o2) {
                return o1.getId() - o2.getId();
            }
        });
        ArrayList<TextEditorHighlightingPass> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "getAllSubmittedPasses"));
        }
        return arrayList;
    }

    private static int getThreadNum() {
        return (Integer)ConcurrencyUtil.cacheOrGet(threads, (Object)Thread.currentThread(), (Object)threads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void log(ProgressIndicator progressIndicator, TextEditorHighlightingPass pass, Object ... info) {
        if (!LOG.isDebugEnabled()) return;
        String docText = pass == null ? "" : StringUtil.first((CharSequence)pass.getDocument().getCharsSequence(), (int)10, (boolean)true);
        Class<PassExecutorService> clazz = PassExecutorService.class;
        synchronized (PassExecutorService.class) {
            StringBuilder s = new StringBuilder();
            for (Object o : info) {
                s.append(o.toString()).append(" ");
            }
            String message = StringUtil.repeatSymbol((char)' ', (int)(PassExecutorService.getThreadNum() * 4)) + " " + pass + " " + s + "; progress=" + (progressIndicator == null ? null : Integer.valueOf(progressIndicator.hashCode())) + " " + (progressIndicator == null ? "?" : (progressIndicator.isCanceled() ? "X" : "V")) + " : '" + docText + "'";
            LOG.debug(message);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static void saveException(Throwable e, DaemonProgressIndicator indicator) {
        indicator.putUserDataIfAbsent(THROWABLE_KEY, e);
    }

    public static Throwable getSavedException(DaemonProgressIndicator indicator) {
        return (Throwable)indicator.getUserData(THROWABLE_KEY);
    }

    public boolean waitFor(int millis) throws Throwable {
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            for (Job<Void> job : this.mySubmittedPasses.values()) {
                job.waitForCompletion(millis);
            }
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private class ScheduledPass
    implements Runnable {
        private final List<FileEditor> myFileEditors;
        private final TextEditorHighlightingPass myPass;
        private final AtomicInteger myThreadsToStartCountdown;
        private final int myJobPriority;
        private final AtomicInteger myRunningPredecessorsCount;
        private final Collection<ScheduledPass> mySuccessorsOnCompletion;
        private final Collection<ScheduledPass> mySuccessorsOnSubmit;
        private final DaemonProgressIndicator myUpdateProgress;

        private ScheduledPass(@NotNull List<FileEditor> fileEditors, @NotNull TextEditorHighlightingPass pass, @NotNull DaemonProgressIndicator progressIndicator, AtomicInteger threadsToStartCountdown, int jobPriority) {
            if (fileEditors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "<init>"));
            }
            if (pass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "<init>"));
            }
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "<init>"));
            }
            if (threadsToStartCountdown == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "<init>"));
            }
            this.mySuccessorsOnCompletion = new ArrayList<ScheduledPass>();
            this.mySuccessorsOnSubmit = new ArrayList<ScheduledPass>();
            this.myFileEditors = fileEditors;
            this.myPass = pass;
            this.myThreadsToStartCountdown = threadsToStartCountdown;
            this.myJobPriority = jobPriority;
            this.myRunningPredecessorsCount = new AtomicInteger(0);
            this.myUpdateProgress = progressIndicator;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (RuntimeException e) {
                PassExecutorService.saveException(e, this.myUpdateProgress);
                throw e;
            }
            catch (Error e) {
                PassExecutorService.saveException(e, this.myUpdateProgress);
                throw e;
            }
        }

        private void doRun() {
            int predecessorsToRun;
            if (this.myUpdateProgress.isCanceled()) {
                return;
            }
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Started. ");
            for (ScheduledPass successor : this.mySuccessorsOnSubmit) {
                predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                if (predecessorsToRun != 0) continue;
                PassExecutorService.this.submit(successor);
            }
            ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                @Override
                public void run() {
                    boolean success = ApplicationManagerEx.getApplicationEx().tryRunReadAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (DumbService.getInstance((Project)PassExecutorService.this.myProject).isDumb() && !DumbService.isDumbAware((Object)ScheduledPass.this.myPass)) {
                                    return;
                                }
                                if (!ScheduledPass.this.myUpdateProgress.isCanceled()) {
                                    ScheduledPass.this.myPass.collectInformation(ScheduledPass.this.myUpdateProgress);
                                }
                            }
                            catch (ProcessCanceledException e) {
                                PassExecutorService.log(ScheduledPass.this.myUpdateProgress, ScheduledPass.this.myPass, "Canceled ");
                                if (!ScheduledPass.this.myUpdateProgress.isCanceled()) {
                                    ScheduledPass.this.myUpdateProgress.cancel(e);
                                }
                            }
                            catch (RuntimeException e) {
                                ScheduledPass.this.myUpdateProgress.cancel(e);
                                LOG.error((Throwable)e);
                                throw e;
                            }
                            catch (Error e) {
                                ScheduledPass.this.myUpdateProgress.cancel(e);
                                LOG.error((Throwable)e);
                                throw e;
                            }
                        }
                    });
                    if (!success) {
                        ScheduledPass.this.myUpdateProgress.cancel();
                    }
                }
            }, (ProgressIndicator)this.myUpdateProgress);
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Finished. ");
            if (!this.myUpdateProgress.isCanceled()) {
                PassExecutorService.this.applyInformationToEditorsLater(this.myFileEditors, this.myPass, this.myUpdateProgress, this.myThreadsToStartCountdown);
                for (ScheduledPass successor : this.mySuccessorsOnCompletion) {
                    predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                    if (predecessorsToRun != 0) continue;
                    PassExecutorService.this.submit(successor);
                }
            }
        }

        @NonNls
        public String toString() {
            return "SP: " + this.myPass;
        }
    }
}

