/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.InjectedGeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedGeneralHighlightingPassFactory
extends AbstractProjectComponent
implements MainHighlightingPassFactory {
    public InjectedGeneralHighlightingPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("InjectedGeneralHighlightingPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPassFactory", "getComponentName"));
        }
        return "InjectedGeneralHighlightingPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPassFactory", "createHighlightingPass"));
        }
        TextRange textRange = FileStatusMap.getDirtyTextRange(editor, 4);
        if (textRange == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument());
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new InjectedGeneralHighlightingPass(this.myProject, file, editor.getDocument(), textRange.getStartOffset(), textRange.getEndOffset(), true, visibleRange, editor, new DefaultHighlightInfoProcessor());
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPassFactory", "createMainHighlightingPass"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPassFactory", "createMainHighlightingPass"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPassFactory", "createMainHighlightingPass"));
        }
        return new InjectedGeneralHighlightingPass(this.myProject, file, document, 0, document.getTextLength(), true, new ProperTextRange(0, document.getTextLength()), null, highlightInfoProcessor);
    }
}

