/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.DialogUtil;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ImportPopupHectorComponentProvider
implements HectorComponentPanelsProvider {
    public HectorComponentPanel createConfigurable(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ImportPopupHectorComponentProvider", "createConfigurable"));
        }
        Project project = file.getProject();
        final DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null);
        final boolean notInLibrary = !fileIndex.isInLibrarySource(virtualFile) && !fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInContent(virtualFile);
        return new HectorComponentPanel(){
            private JCheckBox myImportPopupCheckBox = new JCheckBox(EditorBundle.message((String)"hector.import.popup.checkbox", (Object[])new Object[0]));

            public JComponent createComponent() {
                DialogUtil.registerMnemonic((AbstractButton)this.myImportPopupCheckBox);
                return this.myImportPopupCheckBox;
            }

            public boolean isModified() {
                return this.myImportPopupCheckBox.isSelected() != analyzer.isImportHintsEnabled(file);
            }

            public void apply() throws ConfigurationException {
                analyzer.setImportHintsEnabled(file, this.myImportPopupCheckBox.isSelected());
            }

            public void reset() {
                this.myImportPopupCheckBox.setSelected(analyzer.isImportHintsEnabled(file));
                this.myImportPopupCheckBox.setEnabled(analyzer.isAutohintsAvailable(file));
                this.myImportPopupCheckBox.setVisible(notInLibrary);
            }

            public void disposeUIResources() {
                this.myImportPopupCheckBox = null;
            }
        };
    }
}

