/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconLineMarkerProvider
implements LineMarkerProvider {
    @NonNls
    private static final String JAVAX_SWING_ICON = "javax.swing.Icon";
    private static final int ICON_MAX_WEIGHT = 16;
    private static final int ICON_MAX_HEIGHT = 16;
    private static final int ICON_MAX_SIZE = 0x200000;
    private static final List<String> ICON_EXTS = Arrays.asList("png", "ico", "bmp", "gif", "jpg");
    private final HashMap<String, Pair<Long, Icon>> iconsCache = new HashMap();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/IconLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (!DaemonCodeAnalyzerSettings.getInstance().SHOW_SMALL_ICONS_IN_GUTTER) {
            return null;
        }
        if (element instanceof PsiAssignmentExpression) {
            PsiElement var;
            PsiExpression lExpression = ((PsiAssignmentExpression)element).getLExpression();
            PsiExpression expr = ((PsiAssignmentExpression)element).getRExpression();
            if (lExpression instanceof PsiReferenceExpression && (var = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
                return this.resolveIconInfo(((PsiVariable)var).getType(), expr);
            }
        } else if (element instanceof PsiReturnStatement) {
            PsiReturnStatement psiReturnStatement = (PsiReturnStatement)element;
            PsiExpression value = psiReturnStatement.getReturnValue();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method != null) {
                PsiType returnType = method.getReturnType();
                LineMarkerInfo<PsiElement> result = this.resolveIconInfo(returnType, value);
                if (result != null || !IconLineMarkerProvider.isIconClassType(returnType) || value == null) {
                    return result;
                }
                if (IconLineMarkerProvider.methodContainsReturnStatementOnly(method)) {
                    for (PsiReference ref : value.getReferences()) {
                        PsiElement field = ref.resolve();
                        if (!(field instanceof PsiField)) continue;
                        return this.resolveIconInfo(returnType, ((PsiField)field).getInitializer(), (PsiElement)psiReturnStatement);
                    }
                }
            }
        } else if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            return this.resolveIconInfo(var.getType(), var.getInitializer());
        }
        return null;
    }

    private static boolean methodContainsReturnStatementOnly(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/IconLineMarkerProvider", "methodContainsReturnStatementOnly"));
        }
        PsiCodeBlock body = method.getBody();
        if (body == null || body.getStatements().length != 1) {
            return false;
        }
        return body.getStatements()[0] instanceof PsiReturnStatement;
    }

    @Nullable
    private LineMarkerInfo<PsiElement> resolveIconInfo(PsiType type, PsiExpression initializer) {
        return this.resolveIconInfo(type, initializer, (PsiElement)initializer);
    }

    @Nullable
    private LineMarkerInfo<PsiElement> resolveIconInfo(PsiType type, PsiExpression initializer, PsiElement bindingElement) {
        if (initializer != null && initializer.isValid() && IconLineMarkerProvider.isIconClassType(type)) {
            final Project project = initializer.getProject();
            final ArrayList refs = new ArrayList();
            initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (element instanceof PsiLiteralExpression) {
                        for (PsiReference ref : element.getReferences()) {
                            if (!(ref instanceof FileReference)) continue;
                            refs.add((FileReference)ref);
                        }
                    }
                    super.visitElement(element);
                }
            });
            for (FileReference ref : refs) {
                Icon icon;
                PsiFileSystemItem psiFileSystemItem = ref.resolve();
                VirtualFile file = null;
                if (psiFileSystemItem == null) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = ref.multiResolve(false)) {
                        PsiElement element = result.getElement();
                        if (!(element instanceof PsiBinaryFile)) continue;
                        file = ((PsiFile)element).getVirtualFile();
                        break;
                    }
                } else {
                    file = psiFileSystemItem.getVirtualFile();
                }
                if (file == null || file.isDirectory() || !IconLineMarkerProvider.isIconFileExtension(file.getExtension()) || file.getLength() > 0x200000L || (icon = this.getIcon(file, project)) == null) continue;
                final Ref f = Ref.create((Object)file);
                GutterIconNavigationHandler<PsiElement> navHandler = new GutterIconNavigationHandler<PsiElement>(){

                    public void navigate(MouseEvent e, PsiElement elt) {
                        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)f.get(), true);
                    }
                };
                return new LineMarkerInfo(bindingElement, bindingElement.getTextRange(), icon, 4, null, (GutterIconNavigationHandler)navHandler, GutterIconRenderer.Alignment.LEFT);
            }
        }
        return null;
    }

    private static boolean isIconFileExtension(String extension) {
        return extension != null && ICON_EXTS.contains(extension.toLowerCase());
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/IconLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/IconLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    private static boolean hasProperSize(Icon icon) {
        return icon.getIconHeight() <= 16 && icon.getIconWidth() <= 16;
    }

    @Nullable
    private Icon getIcon(VirtualFile file, Project project) {
        String path = file.getPath();
        long stamp = file.getModificationStamp();
        Pair iconInfo = this.iconsCache.get(path);
        if (iconInfo == null || (Long)iconInfo.getFirst() < stamp) {
            try {
                Icon icon = IconLineMarkerProvider.createOrFindBetterIcon(file, IconLineMarkerProvider.isIdeaProject(project));
                iconInfo = new Pair((Object)stamp, (Object)(IconLineMarkerProvider.hasProperSize(icon) ? icon : null));
                this.iconsCache.put(file.getPath(), (Pair<Long, Icon>)iconInfo);
            }
            catch (Exception e) {
                iconInfo = null;
                this.iconsCache.remove(path);
            }
        }
        return iconInfo == null ? null : (Icon)iconInfo.getSecond();
    }

    private static boolean isIdeaProject(Project project) {
        if (project == null) {
            return false;
        }
        VirtualFile baseDir = project.getBaseDir();
        return baseDir != null && (baseDir.findChild("idea.iml") != null || baseDir.findChild("community-main.iml") != null);
    }

    private static Icon createOrFindBetterIcon(VirtualFile file, boolean tryToFindBetter) throws IOException {
        if (tryToFindBetter) {
            VirtualFile newFile;
            VirtualFile parent = file.getParent();
            String name = file.getNameWithoutExtension();
            String ext = file.getExtension();
            boolean retina = UIUtil.isRetina();
            boolean dark = UIUtil.isUnderDarcula();
            if (retina && dark && (newFile = parent.findChild(name + "@2x_dark." + ext)) != null) {
                return IconLineMarkerProvider.loadIcon(newFile, 2);
            }
            if (dark && (newFile = parent.findChild(name + "_dark." + ext)) != null) {
                return IconLineMarkerProvider.loadIcon(file, 1);
            }
            if (retina && (newFile = parent.findChild(name + "@2x." + ext)) != null) {
                return IconLineMarkerProvider.loadIcon(newFile, 2);
            }
        }
        return new ImageIcon(file.contentsToByteArray());
    }

    private static ImageIcon loadIcon(VirtualFile file, int scale) throws IOException {
        return new ImageIcon(ImageLoader.loadFromStream((InputStream)file.getInputStream(), (int)scale));
    }

    private static boolean isIconClassType(PsiType type) {
        return InheritanceUtil.isInheritor((PsiType)type, (String)JAVAX_SWING_ICON);
    }
}

