/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightInfoProcessor
extends HighlightInfoProcessor {
    private final Alarm repaintIconAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    @Override
    public void highlightsInsideVisiblePartAreProduced(final @NotNull HighlightingSession highlightingSession, final @NotNull List<HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictRange) {
        if (highlightingSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsInsideVisiblePartAreProduced"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsInsideVisiblePartAreProduced"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsInsideVisiblePartAreProduced"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsInsideVisiblePartAreProduced"));
        }
        final PsiFile psiFile = highlightingSession.getPsiFile();
        final Project project = psiFile.getProject();
        final Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return;
        }
        final long modificationStamp = document.getModificationStamp();
        final TextRange priorityIntersection = priorityRange.intersection(restrictRange);
        final Editor editor = highlightingSession.getEditor();
        if (priorityIntersection == null) {
            DefaultHighlightInfoProcessor.showAutoImportPopups(editor, project, psiFile);
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed() || modificationStamp != document.getModificationStamp()) {
                        return;
                    }
                    MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project, true);
                    EditorColorsScheme scheme = editor == null ? null : editor.getColorsScheme();
                    UpdateHighlightersUtil.setHighlightersInRange(project, document, priorityIntersection, scheme, infos, (MarkupModelEx)markupModel, highlightingSession.getPassId());
                    DefaultHighlightInfoProcessor.showAutoImportPopups(editor, project, psiFile);
                    if (editor != null) {
                        DaemonListeners.repaintErrorStripeRenderer(editor, project);
                    }
                }
            });
        }
    }

    private static void showAutoImportPopups(Editor editor, Project project, PsiFile psiFile) {
        if (editor != null) {
            new ShowAutoImportPass(project, psiFile, editor).applyInformationToEditor();
        }
    }

    @Override
    public void highlightsOutsideVisiblePartAreProduced(final @NotNull HighlightingSession highlightingSession, final @NotNull List<HighlightInfo> infos, final @NotNull TextRange priorityRange, final @NotNull TextRange restrictedRange) {
        if (highlightingSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsOutsideVisiblePartAreProduced"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsOutsideVisiblePartAreProduced"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsOutsideVisiblePartAreProduced"));
        }
        if (restrictedRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsOutsideVisiblePartAreProduced"));
        }
        final PsiFile psiFile = highlightingSession.getPsiFile();
        final Project project = psiFile.getProject();
        final Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return;
        }
        final long modificationStamp = document.getModificationStamp();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed() || modificationStamp != document.getModificationStamp()) {
                    return;
                }
                Editor editor = highlightingSession.getEditor();
                EditorColorsScheme scheme = editor == null ? null : editor.getColorsScheme();
                UpdateHighlightersUtil.setHighlightersOutsideRange(project, document, psiFile, infos, scheme, restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), ProperTextRange.create((Segment)priorityRange), highlightingSession.getPassId());
                if (editor != null) {
                    DaemonListeners.repaintErrorStripeRenderer(editor, project);
                }
            }
        });
    }

    @Override
    public void allHighlightsForRangeAreProduced(@NotNull HighlightingSession highlightingSession, @NotNull TextRange elementRange, @Nullable List<HighlightInfo> infos) {
        if (highlightingSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "allHighlightsForRangeAreProduced"));
        }
        if (elementRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "allHighlightsForRangeAreProduced"));
        }
        PsiFile psiFile = highlightingSession.getPsiFile();
        DefaultHighlightInfoProcessor.killAbandonedHighlightsUnder(psiFile, elementRange, infos, highlightingSession);
    }

    private static void killAbandonedHighlightsUnder(@NotNull PsiFile psiFile, final @NotNull TextRange range, final @Nullable List<HighlightInfo> infos, final @NotNull HighlightingSession highlightingSession) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "killAbandonedHighlightsUnder"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "killAbandonedHighlightsUnder"));
        }
        if (highlightingSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "killAbandonedHighlightsUnder"));
        }
        Project project = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return;
        }
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, range.getStartOffset(), range.getEndOffset(), new Processor<HighlightInfo>(){

            public boolean process(HighlightInfo existing) {
                if (existing.isBijective() && existing.getGroup() == 4 && range.equalsToRange(existing.getActualStartOffset(), existing.getActualEndOffset())) {
                    if (infos != null) {
                        for (HighlightInfo created : infos) {
                            if (!existing.equalsByActualOffset(created)) continue;
                            return true;
                        }
                    }
                    ((HighlightingSessionImpl)highlightingSession).queueDisposeHighlighter(existing.highlighter);
                }
                return true;
            }
        });
    }

    @Override
    public void infoIsAvailable(@NotNull HighlightingSession highlightingSession, @NotNull HighlightInfo info) {
        if (highlightingSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "infoIsAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "infoIsAvailable"));
        }
        HighlightingSessionImpl impl = (HighlightingSessionImpl)highlightingSession;
        impl.queueHighlightInfo(info);
    }

    @Override
    public void progressIsAdvanced(@NotNull HighlightingSession highlightingSession, double progress) {
        if (highlightingSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "progressIsAdvanced"));
        }
        PsiFile file = highlightingSession.getPsiFile();
        Editor editor = highlightingSession.getEditor();
        this.repaintTrafficIcon(file, editor, progress);
    }

    private void repaintTrafficIcon(final @NotNull PsiFile file, final Editor editor, double progress) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "repaintTrafficIcon"));
        }
        if (ApplicationManager.getApplication().isCommandLine()) {
            return;
        }
        if (this.repaintIconAlarm.isEmpty() || progress >= 1.0) {
            this.repaintIconAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    Project myProject = file.getProject();
                    if (myProject.isDisposed()) {
                        return;
                    }
                    Editor myeditor = editor;
                    if (myeditor == null) {
                        myeditor = PsiUtilBase.findEditor((PsiElement)file);
                    }
                    if (myeditor == null || myeditor.isDisposed()) {
                        return;
                    }
                    EditorMarkupModelImpl markup = (EditorMarkupModelImpl)myeditor.getMarkupModel();
                    markup.repaintTrafficLightIcon();
                    DaemonListeners.repaintErrorStripeRenderer(myeditor, myProject);
                }
            }, 50, null);
        }
    }
}

