/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.util.TraceableDisposable;
import org.jetbrains.annotations.NotNull;

public class DaemonProgressIndicator
extends AbstractProgressIndicatorBase {
    private static boolean debug;
    private final TraceableDisposable myTraceableDisposable = new TraceableDisposable(debug ? new Throwable() : null);

    @Override
    public synchronized void stop() {
        super.stop();
        super.cancel();
    }

    public synchronized void stopIfRunning() {
        if (this.isRunning()) {
            this.stop();
        } else {
            super.cancel();
        }
    }

    @Override
    public void cancel() {
        this.myTraceableDisposable.kill("Daemon Progress Canceled");
        super.cancel();
    }

    public void cancel(@NotNull Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/DaemonProgressIndicator", "cancel"));
        }
        this.myTraceableDisposable.kill("Daemon Progress Canceled because of " + cause);
        super.cancel();
    }

    @Override
    public void start() {
        assert (!this.isCanceled()) : "canceled";
        assert (!this.isRunning()) : "running";
        super.start();
    }

    public static void setDebug(boolean debug) {
        DaemonProgressIndicator.debug = debug;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

