/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.PathUIUtils;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final ExtensionPointName<AttachSourcesProvider> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.attachSourcesProvider");
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"add sources to class");
    private final Project myProject;

    public AttachSourcesNotificationProvider(Project project, final EditorNotifications notifications) {
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(final VirtualFile file, FileEditor fileEditor) {
        Object defaultAction;
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        final List<LibraryOrderEntry> libraries = this.findOrderEntriesContainingFile(file);
        if (libraries == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        final String fqn = JavaEditorFileSwapper.getFQN(psiFile);
        if (fqn == null) {
            return null;
        }
        if (JavaEditorFileSwapper.findSourceFile(this.myProject, file) != null) {
            return null;
        }
        final EditorNotificationPanel panel = new EditorNotificationPanel();
        VirtualFile sourceFile = AttachSourcesNotificationProvider.findSourceFile(file);
        if (sourceFile != null) {
            panel.setText(ProjectBundle.message((String)"library.sources.not.attached", (Object[])new Object[0]));
            defaultAction = new AttachJarAsSourcesAction(file);
        } else {
            panel.setText(ProjectBundle.message((String)"library.sources.not.found", (Object[])new Object[0]));
            defaultAction = new ChooseAndAttachSourcesAction(this.myProject, (JComponent)panel);
        }
        ArrayList<AttachSourcesProvider.AttachSourcesAction> actions = new ArrayList<AttachSourcesProvider.AttachSourcesAction>();
        boolean hasNonLightAction = false;
        for (AttachSourcesProvider each : (AttachSourcesProvider[])Extensions.getExtensions(EXTENSION_POINT_NAME)) {
            for (AttachSourcesProvider.AttachSourcesAction action : each.getActions(libraries, psiFile)) {
                if (hasNonLightAction) {
                    if (action instanceof AttachSourcesProvider.LightAttachSourcesAction) {
                        continue;
                    }
                } else if (!(action instanceof AttachSourcesProvider.LightAttachSourcesAction)) {
                    actions.clear();
                    hasNonLightAction = true;
                }
                actions.add(action);
            }
        }
        Collections.sort(actions, new Comparator<AttachSourcesProvider.AttachSourcesAction>(){

            @Override
            public int compare(AttachSourcesProvider.AttachSourcesAction o1, AttachSourcesProvider.AttachSourcesAction o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        actions.add((AttachSourcesProvider.AttachSourcesAction)defaultAction);
        for (final AttachSourcesProvider.AttachSourcesAction each : actions) {
            panel.createActionLabel(GuiUtils.getTextWithoutMnemonicEscaping((String)each.getName()), new Runnable(){

                @Override
                public void run() {
                    if (!Comparing.equal((Object)libraries, (Object)AttachSourcesNotificationProvider.this.findOrderEntriesContainingFile(file))) {
                        Messages.showErrorDialog((Project)AttachSourcesNotificationProvider.this.myProject, (String)("Cannot find library for " + StringUtil.getShortName((String)fqn)), (String)"Error");
                        return;
                    }
                    panel.setText(each.getBusyText());
                    Runnable onFinish = new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    panel.setText(ProjectBundle.message((String)"library.sources.not.found", (Object[])new Object[0]));
                                }
                            });
                        }
                    };
                    ActionCallback callback = each.perform(AttachSourcesNotificationProvider.this.findOrderEntriesContainingFile(file));
                    callback.doWhenRejected(onFinish);
                    callback.doWhenDone(onFinish);
                }
            });
        }
        return panel;
    }

    @Nullable
    private static VirtualFile findSourceFile(VirtualFile classFile) {
        VirtualFile parent = classFile.getParent();
        String name = classFile.getName();
        int i = name.indexOf(36);
        if (i != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.indexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        return parent.findChild(name + ".java");
    }

    private static void appendSources(final Library library, final VirtualFile[] files) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Library.ModifiableModel model = library.getModifiableModel();
                for (VirtualFile virtualFile : files) {
                    model.addRoot(virtualFile, OrderRootType.SOURCES);
                }
                model.commit();
            }
        });
    }

    @Nullable
    private List<LibraryOrderEntry> findOrderEntriesContainingFile(VirtualFile file) {
        ArrayList<LibraryOrderEntry> libs = new ArrayList<LibraryOrderEntry>();
        List entries = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            libs.add((LibraryOrderEntry)entry);
        }
        return libs.isEmpty() ? null : libs;
    }

    private static class ChooseAndAttachSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final Project myProject;
        private final JComponent myParentComponent;

        public ChooseAndAttachSourcesAction(Project project, JComponent parentComponent) {
            this.myProject = project;
            this.myParentComponent = parentComponent;
        }

        public String getName() {
            return ProjectBundle.message((String)"module.libraries.attach.sources.button", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
        }

        public ActionCallback perform(List<LibraryOrderEntry> libraries) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            descriptor.setTitle(ProjectBundle.message((String)"library.attach.sources.action", (Object[])new Object[0]));
            descriptor.setDescription(ProjectBundle.message((String)"library.attach.sources.description", (Object[])new Object[0]));
            Library firstLibrary = libraries.get(0).getLibrary();
            VirtualFile[] roots = firstLibrary != null ? firstLibrary.getFiles(OrderRootType.CLASSES) : VirtualFile.EMPTY_ARRAY;
            VirtualFile[] candidates = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, roots.length == 0 ? null : PathUtil.getLocalFile((VirtualFile)roots[0]));
            final VirtualFile[] files = PathUIUtils.scanAndSelectDetectedJavaSourceRoots(this.myParentComponent, candidates);
            if (files.length == 0) {
                return new ActionCallback.Rejected();
            }
            HashMap librariesToAppendSourcesTo = new HashMap();
            for (LibraryOrderEntry library : libraries) {
                librariesToAppendSourcesTo.put(library.getLibrary(), library);
            }
            if (librariesToAppendSourcesTo.size() == 1) {
                AttachSourcesNotificationProvider.appendSources(firstLibrary, files);
            } else {
                librariesToAppendSourcesTo.put(null, null);
                Collection orderEntries = librariesToAppendSourcesTo.values();
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<LibraryOrderEntry>("<html><body>Multiple libraries contain file.<br> Choose libraries to attach sources to</body></html>", orderEntries.toArray(new LibraryOrderEntry[orderEntries.size()]), (Map)librariesToAppendSourcesTo){
                    final /* synthetic */ Map val$librariesToAppendSourcesTo;
                    {
                        this.val$librariesToAppendSourcesTo = map;
                        super(x0, (Object[])x1);
                    }

                    public ListSeparator getSeparatorAbove(LibraryOrderEntry value) {
                        return value == null ? new ListSeparator() : null;
                    }

                    @NotNull
                    public String getTextFor(LibraryOrderEntry value) {
                        if (value != null) {
                            String string = value.getPresentableName() + " (" + value.getOwnerModule().getName() + ")";
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$ChooseAndAttachSourcesAction$1", "getTextFor"));
                            }
                            return string;
                        }
                        if ("All" == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$ChooseAndAttachSourcesAction$1", "getTextFor"));
                        }
                        return "All";
                    }

                    public PopupStep onChosen(LibraryOrderEntry libraryOrderEntry, boolean finalChoice) {
                        if (libraryOrderEntry != null) {
                            AttachSourcesNotificationProvider.appendSources(libraryOrderEntry.getLibrary(), files);
                        } else {
                            for (Library libOrderEntry : this.val$librariesToAppendSourcesTo.keySet()) {
                                if (libOrderEntry == null) continue;
                                AttachSourcesNotificationProvider.appendSources(libOrderEntry, files);
                            }
                        }
                        return FINAL_CHOICE;
                    }
                }).showCenteredInCurrentWindow(this.myProject);
            }
            return new ActionCallback.Done();
        }
    }

    private static class AttachJarAsSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final VirtualFile myClassFile;

        public AttachJarAsSourcesAction(VirtualFile classFile) {
            this.myClassFile = classFile;
        }

        public String getName() {
            return ProjectBundle.message((String)"module.libraries.attach.sources.immediately.button", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
        }

        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            final ArrayList<Library.ModifiableModel> modelsToCommit = new ArrayList<Library.ModifiableModel>();
            for (LibraryOrderEntry orderEntry : orderEntriesContainingFile) {
                VirtualFile root;
                Library library = orderEntry.getLibrary();
                if (library == null || (root = this.findRoot(library)) == null) continue;
                Library.ModifiableModel model = library.getModifiableModel();
                model.addRoot(root, OrderRootType.SOURCES);
                modelsToCommit.add(model);
            }
            if (modelsToCommit.isEmpty()) {
                return new ActionCallback.Rejected();
            }
            new WriteAction(){

                protected void run(Result result) {
                    for (Library.ModifiableModel model : modelsToCommit) {
                        model.commit();
                    }
                }
            }.execute();
            return new ActionCallback.Done();
        }

        @Nullable
        private VirtualFile findRoot(Library library) {
            for (VirtualFile classesRoot : library.getFiles(OrderRootType.CLASSES)) {
                if (!VfsUtil.isAncestor((VirtualFile)classesRoot, (VirtualFile)this.myClassFile, (boolean)true)) continue;
                return classesRoot;
            }
            return null;
        }
    }
}

