/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspection;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class JavaAwareInspectionProfileCoverter
extends InspectionProfileConvertor {
    private String myAdditionalJavadocTags;
    @NonNls
    private static final String ADDITONAL_JAVADOC_TAGS_OPTION = "ADDITIONAL_JAVADOC_TAGS";

    public JavaAwareInspectionProfileCoverter(InspectionProfileManager manager) {
        super(manager);
    }

    @Override
    protected boolean processElement(Element option, String name) {
        if (super.processElement(option, name)) {
            return true;
        }
        if (name.equals(ADDITONAL_JAVADOC_TAGS_OPTION)) {
            this.myAdditionalJavadocTags = option.getAttributeValue("value");
            return true;
        }
        return false;
    }

    @Override
    protected void fillErrorLevels(ModifiableModel profile) {
        super.fillErrorLevels(profile);
        InspectionToolWrapper toolWrapper = profile.getInspectionTool("JavaDoc", null);
        JavaDocLocalInspection inspection = (JavaDocLocalInspection)toolWrapper.getTool();
        inspection.myAdditionalJavadocTags = this.myAdditionalJavadocTags;
    }
}

