/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class XmlNameCompletionConfidence
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldFocusLookup(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/XmlNameCompletionConfidence", "shouldFocusLookup"));
        }
        ASTNode node = parameters.getPosition().getNode();
        if (node == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/XmlNameCompletionConfidence", "shouldFocusLookup"));
            }
            return threeState;
        }
        IElementType elementType = node.getElementType();
        if (elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/XmlNameCompletionConfidence", "shouldFocusLookup"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/XmlNameCompletionConfidence", "shouldFocusLookup"));
        }
        return threeState;
    }
}

