/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.DefaultInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartCompletionDecorator
extends TailTypeDecorator<LookupElement> {
    @NotNull
    private final Collection<ExpectedTypeInfo> myExpectedTypeInfos;
    private PsiElement myPosition;

    public SmartCompletionDecorator(LookupElement item, Collection<ExpectedTypeInfo> expectedTypeInfos) {
        super(item);
        this.myExpectedTypeInfos = expectedTypeInfos;
    }

    @Override
    protected TailType computeTailType(InsertionContext context) {
        if (context.getCompletionChar() == '\r') {
            return TailType.NONE;
        }
        if (LookupItem.getDefaultTailType(context.getCompletionChar()) != null) {
            return null;
        }
        LookupElement delegate = this.getDelegate();
        LookupItem item = (LookupItem)this.as(LookupItem.CLASS_CONDITION_KEY);
        Object object = delegate.getObject();
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && (object instanceof PsiMethod || object instanceof PsiClass)) {
            return TailType.NONE;
        }
        PsiExpression enclosing = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)this.myPosition, PsiExpression.class, (boolean)true);
        if (enclosing != null && object instanceof PsiElement) {
            TailType itemType;
            PsiType type = JavaCompletionUtil.getLookupElementType(delegate);
            TailType tailType = itemType = item != null ? item.getTailType() : TailType.NONE;
            if (type != null && type.isValid()) {
                HashSet<TailType> voidTyped = new HashSet<TailType>();
                HashSet<TailType> sameTyped = new HashSet<TailType>();
                HashSet<TailType> assignableTyped = new HashSet<TailType>();
                for (ExpectedTypeInfo info : this.myExpectedTypeInfos) {
                    PsiType infoType = info.getType();
                    PsiType originalInfoType = JavaCompletionUtil.originalize(infoType);
                    if (PsiType.VOID.equals((Object)infoType)) {
                        voidTyped.add(info.getTailType());
                        continue;
                    }
                    if (infoType.equals(type) || originalInfoType.equals(type)) {
                        sameTyped.add(info.getTailType());
                        continue;
                    }
                    if ((info.getKind() != 1 || !infoType.isAssignableFrom(type) && !originalInfoType.isAssignableFrom(type)) && (info.getKind() != 2 || !type.isAssignableFrom(infoType) && !type.isAssignableFrom(originalInfoType))) continue;
                    assignableTyped.add(info.getTailType());
                }
                if (!sameTyped.isEmpty()) {
                    return sameTyped.size() == 1 ? (TailType)sameTyped.iterator().next() : itemType;
                }
                if (!assignableTyped.isEmpty()) {
                    return assignableTyped.size() == 1 ? (TailType)assignableTyped.iterator().next() : itemType;
                }
                if (!voidTyped.isEmpty()) {
                    return voidTyped.size() == 1 ? (TailType)voidTyped.iterator().next() : itemType;
                }
            } else if (this.myExpectedTypeInfos.size() == 1) {
                return this.myExpectedTypeInfos.iterator().next().getTailType();
            }
            return itemType;
        }
        return null;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        if (this.getObject() instanceof PsiVariable && context.getCompletionChar() == '\t') {
            context.commitDocument();
            DefaultInsertHandler.removeEndOfIdentifier(context);
            context.commitDocument();
        }
        this.myPosition = SmartCompletionDecorator.getPosition(context, (LookupElement)this);
        super.handleInsert(context);
    }

    public static boolean hasUnboundTypeParams(PsiMethod method, PsiType expectedType) {
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (typeParameters.length == 0) {
            return false;
        }
        THashSet set = new THashSet(Arrays.asList(typeParameters));
        PsiTypeVisitor<Boolean> typeParamSearcher = new PsiTypeVisitor<Boolean>((Set)set){
            final /* synthetic */ Set val$set;
            {
                this.val$set = set;
            }

            public Boolean visitType(PsiType type) {
                return true;
            }

            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            public Boolean visitClassType(PsiClassType classType) {
                PsiType[] types;
                PsiClass aClass = classType.resolve();
                if (aClass instanceof PsiTypeParameter && this.val$set.contains(aClass)) {
                    return false;
                }
                for (PsiType psiType : types = classType.getParameters()) {
                    if (((Boolean)psiType.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return false;
                }
                return true;
            }

            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                return bound == null || (Boolean)bound.accept((PsiTypeVisitor)this) != false;
            }
        };
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (((Boolean)parameter.getType().accept((PsiTypeVisitor)typeParamSearcher)).booleanValue()) continue;
            return false;
        }
        PsiSubstitutor substitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, expectedType);
        for (PsiTypeParameter parameter : typeParameters) {
            if (TypeConversionUtil.typeParameterErasure((PsiTypeParameter)parameter).equals(substitutor.substitute(parameter))) continue;
            return true;
        }
        return false;
    }

    public static PsiSubstitutor calculateMethodReturnTypeSubstitutor(PsiMethod method, PsiType expected) {
        PsiTypeParameter[] typeParameters;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
        for (PsiTypeParameter typeParameter : typeParameters = method.getTypeParameters()) {
            PsiType substitution = helper.getSubstitutionForTypeParameter(typeParameter, method.getReturnType(), expected, false, PsiUtil.getLanguageLevel((PsiElement)method));
            if (PsiType.NULL.equals((Object)substitution)) {
                substitution = TypeConversionUtil.typeParameterErasure((PsiTypeParameter)typeParameter);
            }
            substitutor = substitutor.put(typeParameter, substitution);
        }
        return substitutor;
    }

    @Nullable
    public static PsiElement getPosition(InsertionContext context, LookupElement element) {
        PsiElement position = context.getFile().findElementAt(context.getStartOffset() + element.getLookupString().length() - 1);
        if (position instanceof PsiJavaToken && ">".equals(position.getText())) {
            return position.getParent().getParent();
        }
        return position;
    }
}

