/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.proximity.KnownElementWeigher;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PreferByKindWeigher
extends LookupElementWeigher {
    static final ElementPattern<PsiElement> IN_CATCH_TYPE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiCatchSection.class), PsiJavaPatterns.psiElement(PsiVariable.class).withParent(PsiCatchSection.class)}))));
    static final ElementPattern<PsiElement> IN_MULTI_CATCH_TYPE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiCatchSection.class)), PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiParameter.class)).withSuperParent(3, PsiCatchSection.class))});
    static final ElementPattern<PsiElement> INSIDE_METHOD_THROWS_CLAUSE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throws", ","})).inside((ElementPattern)PsiJavaPatterns.psiElement((IElementType)JavaElementType.THROWS_LIST));
    static final ElementPattern<PsiElement> IN_RESOURCE_TYPE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiResourceVariable.class), PsiJavaPatterns.psiElement(PsiResourceList.class)}))));
    private final CompletionType myCompletionType;
    private final PsiElement myPosition;
    private final Set<PsiField> myNonInitializedFields;
    @NotNull
    private final Condition<PsiClass> myRequiredSuper;

    public PreferByKindWeigher(CompletionType completionType, PsiElement position) {
        super("kind");
        this.myCompletionType = completionType;
        this.myPosition = position;
        this.myNonInitializedFields = JavaCompletionProcessor.getNonInitializedFields(position);
        this.myRequiredSuper = PreferByKindWeigher.createSuitabilityCondition(position);
    }

    private static Condition<PsiClass> createSuitabilityCondition(PsiElement position) {
        if (IN_CATCH_TYPE.accepts((Object)position) || IN_MULTI_CATCH_TYPE.accepts((Object)position) || JavaSmartCompletionContributor.AFTER_THROW_NEW.accepts((Object)position) || INSIDE_METHOD_THROWS_CLAUSE.accepts((Object)position)) {
            return new Condition<PsiClass>(){

                public boolean value(PsiClass psiClass) {
                    return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Throwable");
                }
            };
        }
        if (IN_RESOURCE_TYPE.accepts((Object)position)) {
            return new Condition<PsiClass>(){

                public boolean value(PsiClass psiClass) {
                    return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.AutoCloseable");
                }
            };
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).accepts((Object)position)) {
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class);
            assert (annotation != null);
            final PsiAnnotation.TargetType[] targets = PsiImplUtil.getTargetsForLocation(annotation.getOwner());
            return new Condition<PsiClass>(){

                public boolean value(PsiClass psiClass) {
                    return psiClass.isAnnotationType() && PsiImplUtil.findApplicableTarget(psiClass, targets) != null;
                }
            };
        }
        return Condition.FALSE;
    }

    @NotNull
    public MyResult weigh(@NotNull LookupElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
        }
        Object object = item.getObject();
        if (object instanceof PsiKeyword) {
            String keyword = ((PsiKeyword)object).getText();
            if ("return".equals(keyword) && PreferByKindWeigher.isLastStatement((PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiStatement.class))) {
                MyResult myResult = MyResult.probableKeyword;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if ("else".equals(keyword) || "finally".equals(keyword)) {
                MyResult myResult = MyResult.probableKeyword;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if ("true".equals(keyword) || "false".equals(keyword)) {
                boolean inReturn = PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiReturnStatement.class, (boolean)false, (Class[])new Class[]{PsiMember.class}) != null;
                MyResult myResult = inReturn ? MyResult.probableKeyword : MyResult.normal;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
        }
        if (this.myCompletionType == CompletionType.SMART && (object instanceof PsiLocalVariable || object instanceof PsiParameter || object instanceof PsiThisExpression)) {
            MyResult myResult = MyResult.localOrParameter;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (object instanceof String && item.getUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS) == Boolean.TRUE) {
            MyResult myResult = MyResult.superMethodParameters;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (this.myCompletionType == CompletionType.SMART) {
            PsiClass containingClass;
            if (object instanceof PsiMethod && (containingClass = ((PsiMethod)object).getContainingClass()) != null && "java.util.Collections".equals(containingClass.getQualifiedName())) {
                MyResult myResult = MyResult.collectionFactory;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            Boolean expectedTypeMember = (Boolean)item.getUserData(MembersGetter.EXPECTED_TYPE_MEMBER);
            if (expectedTypeMember != null) {
                MyResult myResult = expectedTypeMember.booleanValue() ? (object instanceof PsiField ? MyResult.expectedTypeConstant : MyResult.expectedTypeMethod) : MyResult.classNameOrGlobalStatic;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            JavaChainLookupElement chain = (JavaChainLookupElement)item.as(JavaChainLookupElement.CLASS_CONDITION_KEY);
            if (chain != null) {
                Object qualifier = chain.getQualifier().getObject();
                if (qualifier instanceof PsiLocalVariable || qualifier instanceof PsiParameter) {
                    MyResult myResult = MyResult.localOrParameter;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                    }
                    return myResult;
                }
                if (qualifier instanceof PsiField) {
                    MyResult myResult = MyResult.qualifiedWithField;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                    }
                    return myResult;
                }
                if (PreferByKindWeigher.isGetter(qualifier)) {
                    MyResult myResult = MyResult.qualifiedWithGetter;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                    }
                    return myResult;
                }
            }
            if (object instanceof PsiField) {
                MyResult myResult = MyResult.field;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (PreferByKindWeigher.isGetter(object)) {
                MyResult myResult = MyResult.getter;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            MyResult myResult = MyResult.normal;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (this.myCompletionType == CompletionType.BASIC) {
            StaticallyImportable callElement = (StaticallyImportable)item.as(StaticallyImportable.CLASS_CONDITION_KEY);
            if (callElement != null && callElement.canBeImported() && !callElement.willBeImported()) {
                MyResult myResult = MyResult.classNameOrGlobalStatic;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (object instanceof PsiKeyword && "class".equals(item.getLookupString())) {
                MyResult myResult = MyResult.classLiteral;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (object instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)((PsiElement)object))) {
                MyResult myResult = MyResult.annoMethod;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (object instanceof PsiClass) {
                if (this.myRequiredSuper.value((Object)((PsiClass)object))) {
                    MyResult myResult = MyResult.suitableClass;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                    }
                    return myResult;
                }
                MyResult myResult = MyResult.classNameOrGlobalStatic;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (object instanceof PsiField && this.myNonInitializedFields.contains(object)) {
                MyResult myResult = MyResult.nonInitialized;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
        }
        MyResult myResult = MyResult.normal;
        if (myResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
        }
        return myResult;
    }

    private static boolean isGetter(Object object) {
        if (!(object instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)object;
        if (!PropertyUtil.hasGetterName((PsiMethod)method)) {
            return false;
        }
        return !KnownElementWeigher.isGetClass(method);
    }

    private static boolean isLastStatement(PsiStatement statement) {
        if (statement == null || !(statement.getParent() instanceof PsiCodeBlock)) {
            return true;
        }
        PsiStatement[] siblings = ((PsiCodeBlock)statement.getParent()).getStatements();
        return statement == siblings[siblings.length - 1];
    }

    static enum MyResult {
        annoMethod,
        probableKeyword,
        localOrParameter,
        qualifiedWithField,
        qualifiedWithGetter,
        superMethodParameters,
        expectedTypeConstant,
        field,
        getter,
        normal,
        collectionFactory,
        expectedTypeMethod,
        suitableClass,
        nonInitialized,
        classLiteral,
        classNameOrGlobalStatic;

    }
}

