/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCompletionContributor
extends CompletionContributor {
    @Nullable
    public static String getDefaultAdvertisementText(@NotNull CompletionParameters parameters) {
        String shortcut;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/DefaultCompletionContributor", "getDefaultAdvertisementText"));
        }
        Random random = new Random();
        if (random.nextInt(5) < 2 && CompletionUtil.shouldShowFeature(parameters, "editing.completion.finishByDotEtc")) {
            return LangBundle.message("completion.dot.etc.ad", new Object[0]);
        }
        if (random.nextInt(5) < 2 && CompletionUtil.shouldShowFeature(parameters, "editing.completion.finishBySmartEnter") && (shortcut = DefaultCompletionContributor.getActionShortcut((String)"EditorChooseLookupItemCompleteStatement")) != null) {
            return LangBundle.message("completion.smart.enter.ad", shortcut);
        }
        if (random.nextInt(5) < 2 && CompletionUtil.shouldShowFeature(parameters, "editing.completion.finishByDotEtc")) {
            return LangBundle.message("completion.dot.etc.ad", new Object[0]);
        }
        if (random.nextInt(5) < 2 && CompletionUtil.shouldShowFeature(parameters, "editing.completion.finishBySmartEnter") && (shortcut = DefaultCompletionContributor.getActionShortcut((String)"EditorChooseLookupItemCompleteStatement")) != null) {
            return LangBundle.message("completion.smart.enter.ad", shortcut);
        }
        if (random.nextInt(5) < 2 && (CompletionUtil.shouldShowFeature(parameters, "codeassists.quickjavadoc") || CompletionUtil.shouldShowFeature(parameters, "codeassists.quickjavadoc.lookup")) && (shortcut = DefaultCompletionContributor.getActionShortcut((String)"QuickJavaDoc")) != null) {
            return LangBundle.message("completion.quick.javadoc.ad", shortcut);
        }
        if ((CompletionUtil.shouldShowFeature(parameters, "codeassists.quickdefinition") || CompletionUtil.shouldShowFeature(parameters, "codeassists.quickdefinition.lookup")) && (shortcut = DefaultCompletionContributor.getActionShortcut((String)"QuickImplementations")) != null) {
            return LangBundle.message("completion.quick.implementations.ad", shortcut);
        }
        return null;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/DefaultCompletionContributor", "handleEmptyLookup"));
        }
        return LangBundle.message("completion.no.suggestions", new Object[0]);
    }

    public AutoCompletionDecision handleAutoCompletionPossibility(AutoCompletionContext context) {
        LookupElement[] items = context.getItems();
        if (items.length == 1) {
            LookupElement item = items[0];
            if (!StringUtil.isEmpty((String)context.getLookup().itemPattern(item)) || context.getParameters().getCompletionType() == CompletionType.SMART) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
        }
        return null;
    }
}

