/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.application.options.editor.EditorOptions;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.DirectoryFormattingOptions;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LayoutCodeDialog;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.LayoutCodeSettingsStorage;
import com.intellij.codeInsight.actions.LayoutDirectoryDialog;
import com.intellij.codeInsight.actions.LayoutProjectCodeDialog;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.ReformatFilesDialog;
import com.intellij.codeInsight.actions.ReformatFilesOptions;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";
    protected static ReformatFilesOptions myTestOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent event) {
        PsiDirectory dir;
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files == null) {
            return;
        }
        PsiFile file = null;
        boolean hasSelection = false;
        if (editor != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            dir = file.getContainingDirectory();
            hasSelection = editor.getSelectionModel().hasSelection();
        } else {
            if (ReformatCodeAction.areFiles(files)) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files);
                if (!operationStatus.hasReadonlyFiles()) {
                    ReformatFilesOptions selectedFlags = ReformatCodeAction.getReformatFilesOptions(project, files);
                    if (selectedFlags == null) {
                        return;
                    }
                    boolean processOnlyChangedText = selectedFlags.isProcessOnlyChangedText();
                    boolean shouldOptimizeImports = selectedFlags.isOptimizeImports() && !DumbService.getInstance((Project)project).isDumb();
                    AbstractLayoutCodeProcessor processor = new ReformatCodeProcessor(project, ReformatCodeAction.convertToPsiFiles(files, project), null, processOnlyChangedText);
                    if (shouldOptimizeImports) {
                        processor = new OptimizeImportsProcessor(processor);
                    }
                    if (selectedFlags.isRearrangeEntries()) {
                        processor = new RearrangeCodeProcessor(processor, null);
                    }
                    processor.run();
                }
                return;
            }
            Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
            Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
            if (projectContext != null || moduleContext != null) {
                ReformatFilesOptions selectedFlags = ReformatCodeAction.getLayoutProjectOptions(project, moduleContext);
                if (selectedFlags != null) {
                    ReformatCodeAction.reformatModule(project, moduleContext, selectedFlags);
                }
                return;
            }
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                return;
            }
            if (element instanceof PsiDirectoryContainer) {
                dir = ((PsiDirectoryContainer)element).getDirectories()[0];
            } else if (element instanceof PsiDirectory) {
                dir = (PsiDirectory)element;
            } else {
                file = element.getContainingFile();
                if (file == null) {
                    return;
                }
                dir = file.getContainingDirectory();
            }
        }
        boolean optimizeImports = ReformatFilesDialog.isOptmizeImportsOptionOn();
        boolean processWholeFile = false;
        boolean processChangedTextOnly = PropertiesComponent.getInstance().getBoolean("LayoutCode.processChangedText", false);
        boolean rearrangeEntries = ReformatCodeAction.getLastSavedRearrangeCbState(project, file);
        boolean showDialog = EditorSettingsExternalizable.getInstance().getOptions().SHOW_REFORMAT_DIALOG;
        if (file == null && dir != null) {
            DirectoryFormattingOptions options = ReformatCodeAction.getDirectoryFormattingOptions(project, dir);
            if (options != null) {
                ReformatCodeAction.reformatDirectory(project, dir, options);
            }
            return;
        }
        if (showDialog) {
            LayoutCodeOptions selectedFlags = ReformatCodeAction.getLayoutCodeOptions(project, file, dir, hasSelection);
            if (selectedFlags == null) {
                return;
            }
            optimizeImports = selectedFlags.isOptimizeImports();
            rearrangeEntries = selectedFlags.isRearrangeEntries();
            processWholeFile = selectedFlags.isProcessWholeFile();
            processChangedTextOnly = selectedFlags.isProcessOnlyChangedText();
            if (selectedFlags.isProcessDirectory()) {
                assert (dir != null) : "File = " + file + ", Element = " + CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                ReformatCodeAction.reformatDirectory(project, dir, selectedFlags);
                return;
            }
        }
        TextRange range = !processWholeFile && editor != null && editor.getSelectionModel().hasSelection() ? TextRange.create((int)editor.getSelectionModel().getSelectionStart(), (int)editor.getSelectionModel().getSelectionEnd()) : null;
        if (optimizeImports && range == null) {
            new OptimizeImportsProcessor(new ReformatCodeProcessor(project, file, null, processChangedTextOnly)).run();
        } else {
            new ReformatCodeProcessor(project, file, range, processChangedTextOnly).run();
        }
        if (rearrangeEntries && file != null && editor != null) {
            final ArrangementEngine engine = (ArrangementEngine)ServiceManager.getService((Project)project, ArrangementEngine.class);
            try {
                final PsiFile finalFile = file;
                SelectionModel selectionModel = editor.getSelectionModel();
                final TextRange rangeToUse = selectionModel.hasSelection() ? TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd()) : TextRange.create((int)0, (int)editor.getDocument().getTextLength());
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        engine.arrange(editor, finalFile, Collections.singleton(rangeToUse));
                    }
                }, this.getTemplatePresentation().getText(), null);
            }
            finally {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        }
    }

    @Nullable
    private static DirectoryFormattingOptions getDirectoryFormattingOptions(@NotNull Project project, @NotNull PsiDirectory dir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/ReformatCodeAction", "getDirectoryFormattingOptions"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/ReformatCodeAction", "getDirectoryFormattingOptions"));
        }
        LayoutDirectoryDialog dialog = new LayoutDirectoryDialog(project, CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]), CodeInsightBundle.message((String)"process.scope.directory", (Object[])new Object[]{dir.getVirtualFile().getPath()}), FormatChangedTextUtil.hasChanges(dir));
        boolean enableIncludeDirectoriesCb = dir.getSubdirectories().length > 0;
        dialog.setEnabledIncludeSubdirsCb(enableIncludeDirectoriesCb);
        dialog.setSelectedIncludeSubdirsCb(enableIncludeDirectoriesCb);
        dialog.show();
        if (dialog.isOK()) {
            return dialog;
        }
        return null;
    }

    private static void reformatDirectory(@NotNull Project project, @NotNull PsiDirectory dir, @NotNull DirectoryFormattingOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatDirectory"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatDirectory"));
        }
        AbstractLayoutCodeProcessor processor = new ReformatCodeProcessor(project, dir, options.isIncludeSubdirectories(), options.isProcessOnlyChangedText());
        if (options.isOptimizeImports()) {
            processor = new OptimizeImportsProcessor(processor);
        }
        if (options.isRearrangeEntries()) {
            processor = new RearrangeCodeProcessor(processor, null);
        }
        processor.run();
    }

    private static void reformatModule(@NotNull Project project, @Nullable Module moduleContext, @NotNull ReformatFilesOptions selectedFlags) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatModule"));
        }
        if (selectedFlags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/actions/ReformatCodeAction", "reformatModule"));
        }
        boolean shouldOptimizeImports = selectedFlags.isOptimizeImports() && !DumbService.getInstance((Project)project).isDumb();
        boolean processOnlyChangedText = selectedFlags.isProcessOnlyChangedText();
        AbstractLayoutCodeProcessor processor = moduleContext != null ? new ReformatCodeProcessor(project, moduleContext, processOnlyChangedText) : new ReformatCodeProcessor(project, processOnlyChangedText);
        if (shouldOptimizeImports) {
            processor = new OptimizeImportsProcessor(processor);
        }
        if (selectedFlags.isRearrangeEntries()) {
            processor = new RearrangeCodeProcessor(processor, null);
        }
        processor.run();
    }

    public static void updateShowDialogSetting(LayoutCodeDialog dialog, String title) {
        if (dialog.isDoNotAskMe()) {
            Notifications.Bus.notify((Notification)new Notification("Reformat Code", title, "<html>You can re-enable the dialog on the <a href=''>IDE Settings -> Editor</a> pane</html>", NotificationType.INFORMATION, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/ReformatCodeAction$2", "hyperlinkUpdate"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/ReformatCodeAction$2", "hyperlinkUpdate"));
                    }
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                        IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                        util.editConfigurable((Component)((JFrame)ideFrame), (Configurable)new EditorOptions());
                    }
                }
            }));
        }
    }

    public static PsiFile[] convertToPsiFiles(VirtualFile[] files, Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile = manager.findFile(virtualFile);
            if (psiFile == null) continue;
            result.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(result);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null || file.getVirtualFile() == null) {
                presentation.setEnabled(false);
                return;
            }
            if (LanguageFormatting.INSTANCE.forContext((PsiElement)file) != null) {
                presentation.setEnabled(true);
                return;
            }
        } else if (files != null && ReformatCodeAction.areFiles(files)) {
            boolean anyFormatters = false;
            for (VirtualFile virtualFile : files) {
                if (virtualFile.isDirectory()) {
                    presentation.setEnabled(false);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile == null) {
                    presentation.setEnabled(false);
                    return;
                }
                FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
                if (builder == null) continue;
                anyFormatters = true;
            }
            if (!anyFormatters) {
                presentation.setEnabled(false);
                return;
            }
        } else if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(dataContext) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext) == null) {
            PsiFile file;
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                presentation.setEnabled(false);
                return;
            }
            if (!(element instanceof PsiDirectory || (file = element.getContainingFile()) != null && LanguageFormatting.INSTANCE.forContext((PsiElement)file) != null)) {
                presentation.setEnabled(false);
                return;
            }
        }
        presentation.setEnabled(true);
    }

    @Nullable
    private static ReformatFilesOptions getReformatFilesOptions(@NotNull Project project, @NotNull VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/ReformatCodeAction", "getReformatFilesOptions"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/ReformatCodeAction", "getReformatFilesOptions"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myTestOptions;
        }
        ReformatFilesDialog dialog = new ReformatFilesDialog(project, files);
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        return dialog;
    }

    @Nullable
    private static ReformatFilesOptions getLayoutProjectOptions(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/ReformatCodeAction", "getLayoutProjectOptions"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myTestOptions;
        }
        String text = module != null ? CodeInsightBundle.message((String)"process.scope.module", (Object[])new Object[]{module.getModuleFilePath()}) : CodeInsightBundle.message((String)"process.scope.project", (Object[])new Object[]{project.getPresentableUrl()});
        boolean enableOnlyVCSChangedRegions = module != null ? FormatChangedTextUtil.hasChanges(module) : FormatChangedTextUtil.hasChanges(project);
        LayoutProjectCodeDialog dialog = new LayoutProjectCodeDialog(project, CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]), text, true, enableOnlyVCSChangedRegions);
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        return dialog;
    }

    @Nullable
    private static LayoutCodeOptions getLayoutCodeOptions(@NotNull Project project, @Nullable PsiFile file, @Nullable PsiDirectory dir, boolean hasSelection) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/ReformatCodeAction", "getLayoutCodeOptions"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (LayoutCodeOptions)myTestOptions;
        }
        LayoutCodeDialog dialog = new LayoutCodeDialog(project, CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]), file, dir, hasSelection ? Boolean.TRUE : Boolean.FALSE, HELP_ID);
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        EditorSettingsExternalizable.getInstance().getOptions().SHOW_REFORMAT_DIALOG = !dialog.isDoNotAskMe();
        ReformatCodeAction.updateShowDialogSetting(dialog, "\"Reformat Code\" dialog disabled");
        return dialog;
    }

    public static boolean getLastSavedRearrangeCbState(@NotNull Project project, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/ReformatCodeAction", "getLastSavedRearrangeCbState"));
        }
        if (file != null) {
            return LayoutCodeSettingsStorage.getLastSavedRearrangeEntriesCbStateFor(project, file.getLanguage());
        }
        return LayoutCodeSettingsStorage.getLastSavedRearrangeEntriesCbStateFor(project);
    }

    protected static void setTestOptions(ReformatFilesOptions options) {
        myTestOptions = options;
    }

    public static boolean areFiles(VirtualFile[] files) {
        if (files == null) {
            return false;
        }
        if (files.length < 2) {
            return false;
        }
        for (VirtualFile virtualFile : files) {
            if (!virtualFile.isDirectory()) continue;
            return false;
        }
        return true;
    }
}

