/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.RearrangeCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = "Rearrange code";
    public static final String PROGRESS_TEXT = "Rearranging code...";
    @Nullable
    private Condition<PsiFile> myAcceptCondition;

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @Nullable Condition<PsiFile> acceptCondition) {
        if (previousProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.myAcceptCondition = acceptCondition;
    }

    public RearrangeCodeProcessor(@NotNull Project project, @NotNull PsiFile[] files, @NotNull String commandName, @Nullable Runnable postRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(project, files, PROGRESS_TEXT, commandName, postRunnable, false);
    }

    public boolean shouldRearrangeFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "shouldRearrangeFile"));
        }
        return this.myAcceptCondition == null || this.myAcceptCondition.value((Object)file);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(final @NotNull PsiFile file, boolean processChangedTextOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (!RearrangeCodeProcessor.this.shouldRearrangeFile(file)) {
                    return true;
                }
                RearrangeCommand rearranger = new RearrangeCommand(RearrangeCodeProcessor.this.myProject, file, RearrangeCodeProcessor.COMMAND_NAME);
                if (rearranger.couldRearrange()) {
                    rearranger.run();
                }
                return true;
            }
        });
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        return futureTask;
    }
}

