/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.LayoutCodeSettingsStorage;
import com.intellij.codeInsight.actions.ReformatFilesOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.GridLayout;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LayoutProjectCodeDialog
extends DialogWrapper
implements ReformatFilesOptions {
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";
    private final String myText;
    private final boolean myEnableOnlyVCSChangedTextCb;
    private final boolean mySuggestOptimizeImports;
    private final Project myProject;
    private JCheckBox myCbOptimizeImports;
    private JCheckBox myCbOnlyVcsChangedRegions;
    private JCheckBox myCbRearrangeEntries;

    public LayoutProjectCodeDialog(@NotNull Project project, String title, String text, boolean suggestOptimizeImports, boolean enableOnlyVCSChangedTextCb) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/LayoutProjectCodeDialog", "<init>"));
        }
        super(project, false);
        this.myText = text;
        this.mySuggestOptimizeImports = suggestOptimizeImports;
        this.myProject = project;
        this.myEnableOnlyVCSChangedTextCb = enableOnlyVCSChangedTextCb;
        this.setOKButtonText(CodeInsightBundle.message((String)"reformat.code.accept.button.text", (Object[])new Object[0]));
        this.setTitle(title);
        this.init();
    }

    protected JComponent createCenterPanel() {
        if (!this.mySuggestOptimizeImports) {
            return new JLabel(this.myText);
        }
        JPanel panel = new JPanel(new GridLayout(4, 1));
        this.myCbOptimizeImports = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.optimize.imports", (Object[])new Object[0]));
        this.myCbRearrangeEntries = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.rearrange.entries", (Object[])new Object[0]));
        this.myCbOnlyVcsChangedRegions = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.vcs.changed.region", (Object[])new Object[0]));
        panel.add(new JLabel(this.myText));
        panel.add(this.myCbOptimizeImports);
        panel.add(this.myCbRearrangeEntries);
        panel.add(this.myCbOnlyVcsChangedRegions);
        this.myCbOptimizeImports.setSelected(PropertiesComponent.getInstance().getBoolean("LayoutCode.optimizeImports", false));
        this.myCbRearrangeEntries.setSelected(LayoutCodeSettingsStorage.getLastSavedRearrangeEntriesCbStateFor(this.myProject));
        this.myCbOnlyVcsChangedRegions.setEnabled(this.myEnableOnlyVCSChangedTextCb);
        this.myCbOnlyVcsChangedRegions.setSelected(this.myEnableOnlyVCSChangedTextCb && PropertiesComponent.getInstance().getBoolean("LayoutCode.processChangedText", false));
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/LayoutProjectCodeDialog", "createActions"));
        }
        return actionArray;
    }

    @Override
    public boolean isRearrangeEntries() {
        return this.myCbRearrangeEntries.isSelected();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.mySuggestOptimizeImports) {
            PropertiesComponent.getInstance().setValue("LayoutCode.optimizeImports", Boolean.toString(this.isOptimizeImports()));
            LayoutCodeSettingsStorage.saveRearrangeEntriesOptionFor(this.myProject, this.isRearrangeEntries());
            if (this.myEnableOnlyVCSChangedTextCb) {
                PropertiesComponent.getInstance().setValue("LayoutCode.processChangedText", Boolean.toString(this.myCbOnlyVcsChangedRegions.isSelected()));
            }
        }
    }

    @Override
    public boolean isOptimizeImports() {
        return this.myCbOptimizeImports.isSelected();
    }

    @Override
    public boolean isProcessOnlyChangedText() {
        return this.myCbOnlyVcsChangedRegions.isEnabled() && this.myCbOnlyVcsChangedRegions.isSelected();
    }
}

