/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FormatChangedTextUtil {
    private FormatChangedTextUtil() {
    }

    public static boolean hasChanges(@NotNull PsiFile file) {
        Change change;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (change = ChangeListManager.getInstance((Project)project).getChange(virtualFile)) != null && change.getType() == Change.Type.NEW) {
            return true;
        }
        LineStatusTrackerManagerI manager = LineStatusTrackerManager.getInstance(project);
        if (manager == null) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return false;
        }
        LineStatusTracker lineStatusTracker = manager.getLineStatusTracker(document);
        if (lineStatusTracker == null) {
            return false;
        }
        List<Range> ranges = lineStatusTracker.getRanges();
        if (ranges == null || ranges.isEmpty()) {
            return false;
        }
        for (Range range : ranges) {
            if (range.getType() == 3) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        return FormatChangedTextUtil.hasChanges(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean hasChanges(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        Collection changes = ChangeListManager.getInstance((Project)project).getChangesIn(file);
        for (Change change : changes) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            if (!FormatChangedTextUtil.hasChanges(root, module.getProject())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasChanges(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        ModifiableModuleModel moduleModel = (ModifiableModuleModel)new ReadAction<ModifiableModuleModel>(){

            protected void run(Result<ModifiableModuleModel> result) throws Throwable {
                result.setResult((Object)ModuleManager.getInstance((Project)project).getModifiableModel());
            }
        }.execute().getResultObject();
        try {
            for (Module module : moduleModel.getModules()) {
                if (!FormatChangedTextUtil.hasChanges(module)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            moduleModel.dispose();
        }
    }

    @NotNull
    public static Collection<TextRange> getChanges(@NotNull PsiFile file) {
        Change change;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
        }
        Set<TextRange> defaultResult = Collections.singleton(file.getTextRange());
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (change = ChangeListManager.getInstance((Project)file.getProject()).getChange(virtualFile)) != null && change.getType() == Change.Type.NEW) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        LineStatusTrackerManagerI manager = LineStatusTrackerManager.getInstance(file.getProject());
        if (manager == null) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        LineStatusTracker lineStatusTracker = manager.getLineStatusTracker(document);
        if (lineStatusTracker == null) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        List<Range> ranges = lineStatusTracker.getRanges();
        if (ranges == null || ranges.isEmpty()) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        for (Range range : ranges) {
            RangeHighlighter highlighter;
            if (range.getType() == 3 || (highlighter = range.getHighlighter()) == null) continue;
            result.add(new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset()));
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
        }
        return arrayList;
    }
}

