/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetElementUtilBase {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    public static final int LOOKUP_ITEM_ACCEPTED = 8;
    protected final LanguageExtension<TargetElementEvaluator> targetElementEvaluator = new LanguageExtension("com.intellij.targetElementEvaluator");

    public static TargetElementUtilBase getInstance() {
        return (TargetElementUtilBase)ServiceManager.getService(TargetElementUtilBase.class);
    }

    public int getAllAccepted() {
        return 11;
    }

    public int getDefinitionSearchFlags() {
        return this.getAllAccepted();
    }

    public int getReferenceSearchFlags() {
        return this.getAllAccepted();
    }

    @Nullable
    public static PsiReference findReference(Editor editor) {
        Integer offset;
        PsiReference result = TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset());
        if (result == null && (offset = (Integer)editor.getUserData(EditorActionUtil.EXPECTED_CARET_OFFSET)) != null) {
            result = TargetElementUtilBase.findReference(editor, offset);
        }
        return result;
    }

    @Nullable
    public static PsiReference findReference(Editor editor, int offset) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        }
        offset = TargetElementUtilBase.adjustOffset(file, document, offset);
        if (file instanceof PsiCompiledFile) {
            return ((PsiCompiledFile)file).getDecompiledPsiFile().findReferenceAt(offset);
        }
        return file.findReferenceAt(offset);
    }

    public static int adjustOffset(Document document, int offset) {
        return TargetElementUtilBase.adjustOffset(null, document, offset);
    }

    public static int adjustOffset(@Nullable PsiFile file, Document document, int offset) {
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!TargetElementUtilBase.isIdentifierPart(file, text, offset)) {
            --correctedOffset;
        }
        if (correctedOffset < 0 || !TargetElementUtilBase.isIdentifierPart(file, text, correctedOffset)) {
            return offset;
        }
        return correctedOffset;
    }

    private static boolean isIdentifierPart(@Nullable PsiFile file, CharSequence text, int offset) {
        if (file != null) {
            for (TargetElementEvaluator evaluator : TargetElementUtilBase.getInstance().targetElementEvaluator.allForLanguage(file.getLanguage())) {
                if (!(evaluator instanceof TargetElementEvaluatorEx) || !((TargetElementEvaluatorEx)evaluator).isIdentifierPart(file, text, offset)) continue;
                return true;
            }
        }
        return Character.isJavaIdentifierPart(text.charAt(offset));
    }

    @Nullable
    public static PsiElement findTargetElement(Editor editor, int flags) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiElement result = TargetElementUtilBase.getInstance().findTargetElement(editor, flags, editor.getCaretModel().getOffset());
        if (result != null) {
            return result;
        }
        Integer offset = (Integer)editor.getUserData(EditorActionUtil.EXPECTED_CARET_OFFSET);
        if (offset != null) {
            return TargetElementUtilBase.getInstance().findTargetElement(editor, flags, offset);
        }
        return result;
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/TargetElementUtilBase", "inVirtualSpace"));
        }
        if (offset == editor.getCaretModel().getOffset()) {
            return EditorUtil.inVirtualSpace(editor, editor.getCaretModel().getLogicalPosition());
        }
        return false;
    }

    @Nullable
    public PsiElement findTargetElement(Editor editor, int flags, int offset) {
        PsiElement referenceOrReferencedElement;
        PsiFile file;
        PsiElement element;
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        if ((flags & 8) != 0 && (element = TargetElementUtilBase.getTargetElementFromLookup(project)) != null) {
            return element;
        }
        Document document = editor.getDocument();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null) {
            return null;
        }
        offset = TargetElementUtilBase.adjustOffset(file, document, offset);
        if (file instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        PsiElement element2 = file.findElementAt(offset);
        if ((flags & 1) != 0 && this.isAcceptableReferencedElement(element2, referenceOrReferencedElement = this.getReferenceOrReferencedElement(file, editor, flags, offset))) {
            return referenceOrReferencedElement;
        }
        if (element2 == null) {
            return null;
        }
        if ((flags & 2) != 0) {
            if (element2 instanceof PsiNamedElement) {
                return element2;
            }
            return this.getNamedElement(element2, offset - element2.getTextRange().getStartOffset());
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElementFromLookup(Project project) {
        PsiElement psi;
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(project).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null && item.isValid() && (psi = CompletionUtil.getTargetElement(item)) != null && psi.isValid()) {
            return psi;
        }
        return null;
    }

    protected boolean isAcceptableReferencedElement(PsiElement element, PsiElement referenceOrReferencedElement) {
        return referenceOrReferencedElement != null && referenceOrReferencedElement.isValid();
    }

    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, PsiElement element, PsiElement contextElement) {
        return element;
    }

    @Nullable
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/TargetElementUtilBase", "adjustReference"));
        }
        return null;
    }

    @Nullable
    public PsiElement getNamedElement(final @Nullable PsiElement element, final int offsetInElement) {
        if (element == null) {
            return null;
        }
        final ArrayList targets = ContainerUtil.newArrayList();
        Consumer<PomTarget> consumer = new Consumer<PomTarget>(){

            public void consume(PomTarget target) {
                if (target instanceof PsiDeclaredTarget) {
                    PsiDeclaredTarget declaredTarget = (PsiDeclaredTarget)target;
                    PsiElement navigationElement = declaredTarget.getNavigationElement();
                    TextRange range = declaredTarget.getNameIdentifierRange();
                    if (range != null && !range.shiftRight(navigationElement.getTextRange().getStartOffset()).contains(element.getTextRange().getStartOffset() + offsetInElement)) {
                        return;
                    }
                }
                targets.add(target);
            }
        };
        int offset = offsetInElement;
        for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
            for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
                searcher.findDeclarationsAt(parent, offset, (Consumer)consumer);
                if (targets.isEmpty()) continue;
                PomTarget target = (PomTarget)targets.get(0);
                return target == null ? null : PomService.convertToPsi((Project)element.getProject(), (PomTarget)target);
            }
            offset += parent.getStartOffsetInParent();
        }
        return this.getNamedElement(element);
    }

    @Nullable
    protected PsiElement getNamedElement(@Nullable PsiElement element) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, PsiNamedElement.class, (boolean)false);
        if (parent != null) {
            assert (element != null) : "notnull parent?";
            if (parent.getTextOffset() == element.getTextRange().getStartOffset()) {
                return parent;
            }
        }
        return null;
    }

    @Nullable
    protected PsiElement getReferenceOrReferencedElement(PsiFile file, Editor editor, int flags, int offset) {
        PsiReference ref = TargetElementUtilBase.findReference(editor, offset);
        if (ref == null) {
            return null;
        }
        Language language = ref.getElement().getLanguage();
        List evaluators = this.targetElementEvaluator.allForLanguage(language);
        for (TargetElementEvaluator evaluator : evaluators) {
            PsiElement element = evaluator.getElementByReference(ref, flags);
            if (element == null) continue;
            return element;
        }
        PsiManager manager = file.getManager();
        PsiElement refElement = ref.resolve();
        if (refElement == null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                DaemonCodeAnalyzer.getInstance((Project)manager.getProject()).updateVisibleHighlighters(editor);
            }
            return null;
        }
        return refElement;
    }

    public Collection<PsiElement> getTargetCandidates(PsiReference reference) {
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
            for (ResolveResult r : results) {
                PsiElement element = r.getElement();
                if (!EditSourceUtil.canNavigate((PsiElement)element) && (!(element instanceof Navigatable) || !((Navigatable)element).canNavigateToSource())) continue;
                navigatableResults.add(element);
            }
            return navigatableResults;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof NavigationItem) {
            return Collections.singleton(resolved);
        }
        return Collections.emptyList();
    }

    public PsiElement getGotoDeclarationTarget(PsiElement element, PsiElement navElement) {
        return navElement;
    }

    public boolean includeSelfInGotoImplementation(PsiElement element) {
        TargetElementEvaluator elementEvaluator = element != null ? (TargetElementEvaluator)this.targetElementEvaluator.forLanguage(element.getLanguage()) : null;
        return elementEvaluator == null || elementEvaluator.includeSelfInGotoImplementation(element);
    }

    public boolean acceptImplementationForReference(PsiReference reference, PsiElement element) {
        return true;
    }

    public SearchScope getSearchScope(Editor editor, PsiElement element) {
        return PsiSearchHelper.SERVICE.getInstance((Project)element.getProject()).getUseScope(element);
    }
}

