/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import java.util.Comparator;

public class JavaPsiEquivalenceUtil {
    public static boolean areExpressionsEquivalent(PsiExpression expr1, PsiExpression expr2) {
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr1, (PsiElement)expr2, (Comparator)new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                if (o1 instanceof PsiParameter && o2 instanceof PsiParameter) {
                    PsiElement scope1 = ((PsiParameter)o1).getDeclarationScope();
                    PsiElement scope2 = ((PsiParameter)o2).getDeclarationScope();
                    if ((scope1 instanceof PsiMethod && scope2 instanceof PsiMethod || scope1 instanceof PsiLambdaExpression && scope2 instanceof PsiLambdaExpression) && !scope1.getTextRange().intersects(scope2.getTextRange())) {
                        return ((PsiParameter)o1).getName().compareTo(((PsiParameter)o2).getName());
                    }
                }
                return 1;
            }
        }, (Comparator)new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                if (!o1.textMatches(o2)) {
                    return 1;
                }
                if (o1 instanceof PsiDiamondTypeElementImpl && o2 instanceof PsiDiamondTypeElementImpl) {
                    PsiDiamondType.DiamondInferenceResult otherInferenceResult;
                    PsiDiamondType.DiamondInferenceResult thisInferenceResult = new PsiDiamondTypeImpl(o1.getManager(), (PsiTypeElement)o1).resolveInferredTypes();
                    return thisInferenceResult.equals((Object)(otherInferenceResult = new PsiDiamondTypeImpl(o2.getManager(), (PsiTypeElement)o2).resolveInferredTypes())) ? 0 : 1;
                }
                return 0;
            }
        }, null, (boolean)false);
    }
}

