/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor;

import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public class JavaEditorFileSwapper
extends EditorFileSwapper {
    @Override
    public Pair<VirtualFile, Integer> getFileToSwapTo(Project project, EditorWithProviderComposite editorWithProviderComposite) {
        VirtualFile file = editorWithProviderComposite.getFile();
        VirtualFile sourceFile = JavaEditorFileSwapper.findSourceFile(project, file);
        if (sourceFile == null) {
            return null;
        }
        Integer position = null;
        TextEditorImpl oldEditor = JavaEditorFileSwapper.findSinglePsiAwareEditor(editorWithProviderComposite.getEditors());
        if (oldEditor != null) {
            PsiElement navigationElement;
            PsiCompiledFile clsFile = (PsiCompiledFile)PsiManager.getInstance((Project)project).findFile(file);
            assert (clsFile != null);
            int offset = oldEditor.getEditor().getCaretModel().getOffset();
            PsiElement elementAt = clsFile.findElementAt(offset);
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiMember.class, (boolean)false);
            if (member instanceof PsiClass) {
                boolean isFirstMember = true;
                for (PsiElement e = member.getFirstChild(); e != null; e = e.getNextSibling()) {
                    if (!(e instanceof PsiMember)) continue;
                    if (offset < e.getTextRange().getEndOffset()) {
                        if (isFirstMember) break;
                        member = (PsiMember)e;
                        break;
                    }
                    isFirstMember = false;
                }
            }
            if (member != null && Comparing.equal((Object)(navigationElement = member.getNavigationElement()).getContainingFile().getVirtualFile(), (Object)sourceFile)) {
                position = navigationElement.getTextOffset();
            }
        }
        return Pair.create((Object)sourceFile, position);
    }

    @Nullable
    public static VirtualFile findSourceFile(Project project, VirtualFile eachFile) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(eachFile);
        if (!(psiFile instanceof PsiCompiledFile)) {
            return null;
        }
        String fqn = JavaEditorFileSwapper.getFQN(psiFile);
        if (fqn == null) {
            return null;
        }
        PsiClass clsClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        if (!(clsClass instanceof ClsClassImpl)) {
            return null;
        }
        PsiClass sourceClass = ((ClsClassImpl)clsClass).getSourceMirrorClass();
        if (sourceClass == null) {
            return null;
        }
        VirtualFile result = sourceClass.getContainingFile().getVirtualFile();
        assert (result != null);
        return result;
    }

    @Nullable
    public static String getFQN(PsiFile psiFile) {
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes = ((PsiJavaFile)psiFile).getClasses();
        if (classes.length == 0) {
            return null;
        }
        return classes[0].getQualifiedName();
    }
}

