/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.ComboPopup;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontOptions
extends JPanel
implements OptionsPanel {
    private static List<String> myFontNames;
    private static List<String> myMonospacedFontNames;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher;
    @NotNull
    private final ColorAndFontOptions myOptions;
    @NotNull
    private final JTextField myEditorFontSizeField;
    @NotNull
    private final JTextField myLineSpacingField;
    private final FontNameCombo myPrimaryCombo;
    private final JCheckBox myUseSecondaryFontCheckbox;
    private final FontNameCombo mySecondaryCombo;
    @NotNull
    private final JBCheckBox myOnlyMonospacedCheckBox;
    private boolean myIsInSchemeChange;

    public FontOptions(ColorAndFontOptions options) {
        this(options, ApplicationBundle.message((String)"group.editor.font", (Object[])new Object[0]));
    }

    protected FontOptions(@NotNull ColorAndFontOptions options, String title) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/colors/FontOptions", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
        this.myEditorFontSizeField = new JTextField(4);
        this.myLineSpacingField = new JTextField(4);
        this.myPrimaryCombo = new FontNameCombo(null);
        this.myUseSecondaryFontCheckbox = new JCheckBox(ApplicationBundle.message((String)"secondary.font", (Object[])new Object[0]));
        this.mySecondaryCombo = new FontNameCombo(null);
        this.myOnlyMonospacedCheckBox = new JBCheckBox(ApplicationBundle.message((String)"checkbox.show.only.monospaced.fonts", (Object[])new Object[0]));
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 5, flowx"));
        Insets borderInsets = new Insets(7, 0, 0, 0);
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false, (Insets)borderInsets));
        this.myOptions = options;
        this.add((Component)this.myOnlyMonospacedCheckBox, "sgx b, sx 2");
        this.add((Component)new JLabel(ApplicationBundle.message((String)"primary.font", (Object[])new Object[0])), "newline, ax right");
        this.add((Component)this.myPrimaryCombo, "sgx b");
        this.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.font.size", (Object[])new Object[0])), "gapleft 20");
        this.add(this.myEditorFontSizeField);
        this.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.line.spacing", (Object[])new Object[0])), "gapleft 20");
        this.add(this.myLineSpacingField);
        this.add((Component)new JLabel(ApplicationBundle.message((String)"label.fallback.fonts.list.description", (Object[])new Object[0]), MessageType.INFO.getDefaultIcon(), 2), "newline, sx 5");
        this.add((Component)this.myUseSecondaryFontCheckbox, "newline, ax right");
        this.add((Component)this.mySecondaryCombo, "sgx b");
        this.myOnlyMonospacedCheckBox.setBorder(null);
        this.myUseSecondaryFontCheckbox.setBorder(null);
        this.mySecondaryCombo.setEnabled(false);
        this.myOnlyMonospacedCheckBox.setSelected(EditorColorsManager.getInstance().isUseOnlyMonospacedFonts());
        this.myOnlyMonospacedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorColorsManager.getInstance().setUseOnlyMonospacedFonts(FontOptions.this.myOnlyMonospacedCheckBox.isSelected());
                FontOptions.this.myPrimaryCombo.updateModel();
                FontOptions.this.mySecondaryCombo.updateModel();
            }
        });
        this.myUseSecondaryFontCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontOptions.this.mySecondaryCombo.setEnabled(FontOptions.this.myUseSecondaryFontCheckbox.isSelected());
                FontOptions.this.syncFontFamilies();
            }
        });
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontOptions.this.syncFontFamilies();
                }
            }
        };
        this.myPrimaryCombo.addItemListener(itemListener);
        this.mySecondaryCombo.addItemListener(itemListener);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontOptions.this.syncFontFamilies();
            }
        };
        this.myPrimaryCombo.addActionListener(actionListener);
        this.mySecondaryCombo.addActionListener(actionListener);
        this.myEditorFontSizeField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                if (FontOptions.this.myIsInSchemeChange || !SwingUtilities.isEventDispatchThread()) {
                    return;
                }
                Object selectedFont = FontOptions.this.myPrimaryCombo.getSelectedItem();
                if (selectedFont instanceof String) {
                    FontPreferences fontPreferences = FontOptions.this.getFontPreferences();
                    fontPreferences.register((String)selectedFont, FontOptions.this.getFontSizeFromField());
                }
                FontOptions.this.updateDescription(true);
            }
        });
        this.myEditorFontSizeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    return;
                }
                boolean up = e.getKeyCode() == 38;
                try {
                    int value = Integer.parseInt(FontOptions.this.myEditorFontSizeField.getText());
                    value += up ? 1 : -1;
                    value = Math.min(40, Math.max(4, value));
                    FontOptions.this.myEditorFontSizeField.setText(String.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.myLineSpacingField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                if (FontOptions.this.myIsInSchemeChange) {
                    return;
                }
                float lineSpacing = FontOptions.this.getLineSpacingFromField();
                if (FontOptions.this.getLineSpacing() != lineSpacing) {
                    FontOptions.this.setCurrentLineSpacing(lineSpacing);
                }
                FontOptions.this.updateDescription(true);
            }
        });
        this.myLineSpacingField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    return;
                }
                boolean up = e.getKeyCode() == 38;
                try {
                    float value = Float.parseFloat(FontOptions.this.myLineSpacingField.getText());
                    value += (float)(up ? 1 : -1) * 0.1f;
                    value = Math.min(3.0f, Math.max(0.6f, value));
                    FontOptions.this.myLineSpacingField.setText(String.format(Locale.ENGLISH, "%.1f", Float.valueOf(value)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }

    private int getFontSizeFromField() {
        try {
            return Math.min(40, Math.max(4, Integer.parseInt(this.myEditorFontSizeField.getText())));
        }
        catch (NumberFormatException e) {
            return 12;
        }
    }

    private float getLineSpacingFromField() {
        try {
            return Math.min(3.0f, Math.max(0.6f, Float.parseFloat(this.myLineSpacingField.getText())));
        }
        catch (NumberFormatException e) {
            return 1.0f;
        }
    }

    private void syncFontFamilies() {
        if (this.myIsInSchemeChange) {
            return;
        }
        FontPreferences fontPreferences = this.getFontPreferences();
        fontPreferences.clearFonts();
        String primaryFontFamily = (String)this.myPrimaryCombo.getSelectedItem();
        String secondaryFontFamily = this.mySecondaryCombo.isEnabled() ? (String)this.mySecondaryCombo.getSelectedItem() : null;
        int fontSize = this.getFontSizeFromField();
        if (primaryFontFamily != null) {
            if (!FontPreferences.DEFAULT_FONT_NAME.equals(primaryFontFamily)) {
                fontPreferences.addFontFamily(primaryFontFamily);
            }
            fontPreferences.register(primaryFontFamily, fontSize);
        }
        if (secondaryFontFamily != null) {
            if (!FontPreferences.DEFAULT_FONT_NAME.equals(secondaryFontFamily)) {
                fontPreferences.addFontFamily(secondaryFontFamily);
            }
            fontPreferences.register(secondaryFontFamily, fontSize);
        }
        this.updateDescription(true);
    }

    public static void showReadOnlyMessage(JComponent parent, boolean sharedScheme) {
        if (!sharedScheme) {
            Messages.showMessageDialog((Component)parent, (String)ApplicationBundle.message((String)"error.readonly.scheme.cannot.be.modified", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"title.cannot.modify.readonly.scheme", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        } else {
            Messages.showMessageDialog((Component)parent, (String)ApplicationBundle.message((String)"error.shared.scheme.cannot.be.modified", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"title.cannot.modify.readonly.scheme", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        }
    }

    @Override
    public void updateOptionsList() {
        this.myIsInSchemeChange = true;
        this.myLineSpacingField.setText(Float.toString(this.getLineSpacing()));
        FontPreferences fontPreferences = this.getFontPreferences();
        List fontFamilies = fontPreferences.getEffectiveFontFamilies();
        this.myPrimaryCombo.setSelectedItem(fontPreferences.getFontFamily());
        boolean isThereSecondaryFont = fontFamilies.size() > 1;
        this.myUseSecondaryFontCheckbox.setSelected(isThereSecondaryFont);
        this.mySecondaryCombo.setSelectedItem(isThereSecondaryFont ? (String)fontFamilies.get(1) : null);
        this.myEditorFontSizeField.setText(String.valueOf(fontPreferences.getSize(fontPreferences.getFontFamily())));
        boolean readOnly = ColorAndFontOptions.isReadOnly(this.myOptions.getSelectedScheme());
        this.myPrimaryCombo.setEnabled(!readOnly);
        this.mySecondaryCombo.setEnabled(isThereSecondaryFont && !readOnly);
        this.myOnlyMonospacedCheckBox.setEnabled(!readOnly);
        this.myLineSpacingField.setEnabled(!readOnly);
        this.myEditorFontSizeField.setEditable(!readOnly);
        this.myUseSecondaryFontCheckbox.setEnabled(!readOnly);
        this.myIsInSchemeChange = false;
    }

    @NotNull
    protected FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.getCurrentScheme().getFontPreferences();
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/FontOptions", "getFontPreferences"));
        }
        return fontPreferences;
    }

    protected float getLineSpacing() {
        return this.getCurrentScheme().getLineSpacing();
    }

    protected void setCurrentLineSpacing(float lineSpacing) {
        this.getCurrentScheme().setLineSpacing(lineSpacing);
    }

    @Override
    @Nullable
    public Runnable showOption(String option) {
        return null;
    }

    @Override
    public void applyChangesToScheme() {
    }

    @Override
    public void selectOption(String typeToSelect) {
    }

    protected EditorColorsScheme getCurrentScheme() {
        return this.myOptions.getSelectedScheme();
    }

    private void initFontTables(FontNameCombo popupCallback) {
        if (myFontNames == null) {
            myFontNames = new ArrayList<String>();
            myMonospacedFontNames = new ArrayList<String>();
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)new InitFontsRunnable(popupCallback), ApplicationBundle.message((String)"progress.analyzing.fonts", (Object[])new Object[0]), false, null);
        }
    }

    public boolean updateDescription(boolean modified) {
        EditorColorsScheme scheme = this.myOptions.getSelectedScheme();
        if (modified && (ColorAndFontOptions.isReadOnly(scheme) || ColorSettingsUtil.isSharedScheme(scheme))) {
            FontOptions.showReadOnlyMessage(this, ColorSettingsUtil.isSharedScheme(scheme));
            return false;
        }
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).fontChanged();
        return true;
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Set<String> processListOptions() {
        return new HashSet<String>();
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                c.setFont(new Font((String)value, 0, 14));
            }
            return c;
        }
    }

    private class FontNameCombo
    extends JComboBox {
        private final DefaultComboBoxModel myModel = new DefaultComboBoxModel();
        private Boolean myMonospacedOnly = null;

        private FontNameCombo(String selectedName) {
            this.setModel(this.myModel);
            this.updateModel();
            this.setSelectedItem(selectedName);
        }

        private void updateModel() {
            if (myFontNames == null || myMonospacedFontNames == null) {
                return;
            }
            if (this.myMonospacedOnly == null || this.myMonospacedOnly.booleanValue() != EditorColorsManager.getInstance().isUseOnlyMonospacedFonts()) {
                this.myMonospacedOnly = EditorColorsManager.getInstance().isUseOnlyMonospacedFonts();
                Object tmp = this.getSelectedItem();
                this.myModel.removeAllElements();
                List toAdd = this.myMonospacedOnly != false ? myMonospacedFontNames : myFontNames;
                for (Object o : toAdd) {
                    this.myModel.addElement(o);
                }
                if (this.myModel.getIndexOf(tmp) != -1) {
                    this.setSelectedItem(tmp);
                } else {
                    this.setSelectedItem(FontPreferences.DEFAULT_FONT_NAME);
                }
                this.fireActionEvent();
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this.myModel.getSize() == 0 && anObject != null) {
                this.myModel.addElement(anObject);
            }
            super.setSelectedItem(anObject);
        }

        @Nullable
        private JList getPopupList() {
            ComboPopup popup = (ComboPopup)ReflectionUtil.getField(this.getUI().getClass(), (Object)this.getUI(), ComboPopup.class, (String)"popup");
            return popup != null ? popup.getList() : null;
        }

        @Override
        public void firePopupMenuWillBecomeVisible() {
            JList list;
            super.firePopupMenuWillBecomeVisible();
            if (myFontNames == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FontOptions.this.initFontTables(FontNameCombo.this);
                    }
                });
            }
            if ((list = this.getPopupList()) != null && !(list.getCellRenderer() instanceof MyListCellRenderer)) {
                list.setCellRenderer(new MyListCellRenderer());
            }
        }
    }

    private class InitFontsRunnable
    implements Runnable {
        private final FontNameCombo myPopupCallback;

        private InitFontsRunnable(FontNameCombo popupCallback) {
            this.myPopupCallback = popupCallback;
        }

        @Override
        public void run() {
            String[] fontNames;
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (String fontName : fontNames = graphicsEnvironment.getAvailableFontFamilyNames()) {
                if (fontName.endsWith(".bold") || fontName.endsWith(".italic")) continue;
                try {
                    Font plainFont = new Font(fontName, 0, 12);
                    if (!plainFont.canDisplay('W')) continue;
                    Font boldFont = plainFont.deriveFont(1);
                    if (progress != null) {
                        progress.setText(ApplicationBundle.message((String)"progress.analysing.font", (Object[])new Object[]{fontName}));
                    }
                    FontMetrics plainMetrics = FontOptions.this.getFontMetrics(plainFont);
                    FontMetrics boldMetrics = FontOptions.this.getFontMetrics(boldFont);
                    if (plainMetrics.getDescent() < 0 || boldMetrics.getDescent() < 0 || plainMetrics.getAscent() < 0 || boldMetrics.getAscent() < 0) continue;
                    int plainL = plainMetrics.charWidth('l');
                    int boldL = boldMetrics.charWidth('l');
                    int plainW = plainMetrics.charWidth('W');
                    int boldW = boldMetrics.charWidth('W');
                    int plainSpace = plainMetrics.charWidth(' ');
                    int boldSpace = boldMetrics.charWidth(' ');
                    if (plainL <= 0 || boldL <= 0 || plainW <= 0 || boldW <= 0 || plainSpace <= 0 || boldSpace <= 0) continue;
                    myFontNames.add(fontName);
                    if (plainL != plainW || plainL != boldL || plainW != boldW || plainSpace != boldSpace) continue;
                    myMonospacedFontNames.add(fontName);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    FontOptions.this.myPrimaryCombo.updateModel();
                    FontOptions.this.mySecondaryCombo.updateModel();
                    InitFontsRunnable.this.myPopupCallback.showPopup();
                }
            });
        }
    }
}

