/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.util.TitleWithToolbar;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementMatchingRulesPanel
extends JPanel
implements DataProvider {
    @NotNull
    private final ArrangementMatchingRulesControl myControl;

    public ArrangementMatchingRulesPanel(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider) {
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "<init>"));
        }
        super(new GridBagLayout());
        JBScrollPane scrollPane = new JBScrollPane();
        final JViewport viewport = scrollPane.getViewport();
        ArrangementMatchingRulesControl.RepresentationCallback callback = new ArrangementMatchingRulesControl.RepresentationCallback(){

            @Override
            public void ensureVisible(@NotNull Rectangle r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel$1", "ensureVisible"));
                }
                Rectangle visibleRect = viewport.getViewRect();
                if (r.y <= visibleRect.y) {
                    return;
                }
                int excessiveHeight = r.y + r.height - (visibleRect.y + visibleRect.height);
                if (excessiveHeight <= 0) {
                    return;
                }
                int verticalShift = Math.min(r.y - visibleRect.y, excessiveHeight);
                if (verticalShift > 0) {
                    viewport.setViewPosition(new Point(visibleRect.x, visibleRect.y + verticalShift));
                }
            }
        };
        this.myControl = new ArrangementMatchingRulesControl(settingsManager, colorsProvider, callback);
        scrollPane.setViewportView((Component)((Object)this.myControl));
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myControl), "Arrangement.Rule.Match.Control.Context.Menu", "Arrangement.Rule.Match.Control.Place");
        TitleWithToolbar top = new TitleWithToolbar(ApplicationBundle.message((String)"arrangement.settings.section.match", (Object[])new Object[0]), "Arrangement.Rule.Match.Control.ToolBar", "Arrangement.Rule.Match.Control.ToolBar.Place", (JComponent)((Object)this.myControl));
        this.add((Component)top, new GridBag().coverLine().fillCellHorizontally().weightx(1.0));
        this.add((Component)scrollPane, new GridBag().fillCell().weightx(1.0).weighty(1.0).insets(0, 8, 0, 0));
    }

    @NotNull
    public List<StdArrangementMatchRule> getRules() {
        List<StdArrangementMatchRule> list = this.myControl.getRules();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "getRules"));
        }
        return list;
    }

    public void setRules(@Nullable List<StdArrangementMatchRule> rules) {
        this.myControl.setRules(rules);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (ArrangementMatchingRulesControl.KEY.is(dataId)) {
            return this.myControl;
        }
        return null;
    }
}

