/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.group;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.application.options.codeStyle.arrangement.util.ArrangementRuleIndexControl;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenUiRole;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementGroupingComponent
extends JPanel
implements ArrangementRepresentationAware,
ArrangementEditorAware {
    @NotNull
    private final ArrangementUiComponent myGroupingTypeToken;
    @NotNull
    private final ArrangementRuleIndexControl myRowIndexControl;
    @Nullable
    private final ArrangementUiComponent myOrderTypeToken;

    public ArrangementGroupingComponent(@NotNull CompositeArrangementSettingsToken token, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementStandardSettingsManager settingsManager) throws IllegalArgumentException {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingComponent", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingComponent", "<init>"));
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingComponent", "<init>"));
        }
        ArrayList children = ContainerUtilRt.newArrayList();
        StdArrangementTokenUiRole childRole = null;
        for (CompositeArrangementSettingsToken child : token.getChildren()) {
            if (childRole == null) {
                childRole = child.getRole();
                children.add(child.getToken());
                continue;
            }
            if (!childRole.equals((Object)child.getRole())) {
                throw new IllegalArgumentException(String.format("Can't build a grouping component for token '%s'. Reason: its children has different UI roles (%s and %s)", token, childRole, child.getRole()));
            }
            children.add(child.getToken());
        }
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int maxWidth = 0;
        for (int i = 0; i <= 99; ++i) {
            maxWidth = Math.max(metrics.stringWidth(String.valueOf(i)), maxWidth);
        }
        int height = metrics.getHeight() - metrics.getDescent() - metrics.getLeading();
        int diameter = Math.max(maxWidth, height) * 5 / 3;
        this.myRowIndexControl = new ArrangementRuleIndexControl(diameter, height);
        this.myGroupingTypeToken = ArrangementUtil.buildUiComponent((StdArrangementTokenUiRole)token.getRole(), Collections.singletonList(token.getToken()), (ArrangementColorsProvider)colorsProvider, (ArrangementStandardSettingsManager)settingsManager);
        if (children.size() <= 0) {
            this.myOrderTypeToken = null;
        } else {
            assert (childRole != null);
            this.myOrderTypeToken = ArrangementUtil.buildUiComponent((StdArrangementTokenUiRole)childRole, (List)children, (ArrangementColorsProvider)colorsProvider, (ArrangementStandardSettingsManager)settingsManager);
            this.myGroupingTypeToken.setListener(new ArrangementUiComponent.Listener(){

                public void stateChanged() {
                    ArrangementGroupingComponent.this.myOrderTypeToken.setEnabled(ArrangementGroupingComponent.this.myGroupingTypeToken.isSelected());
                }
            });
        }
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.myRowIndexControl, new GridBag().anchor(10).insets(0, 8, 0, 10));
        this.add((Component)this.myGroupingTypeToken.getUiComponent(), new GridBag().anchor(17).insets(0, 0, 0, 2));
        if (this.myOrderTypeToken != null) {
            this.add((Component)this.myOrderTypeToken.getUiComponent(), new GridBag().anchor(17));
        }
        this.add((Component)new JLabel(" "), new GridBag().weightx(1.0).fillCellHorizontally());
        this.setBackground(UIUtil.getListBackground());
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)3));
        this.setOpaque(!UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderNativeMacLookAndFeel() && !UIUtil.isUnderDarcula());
    }

    @Override
    protected void paintComponent(Graphics g) {
        int baseline;
        Dimension size = this.getSize();
        if (size != null && (baseline = this.myGroupingTypeToken.getBaselineToUse(size.width, size.height)) > 0) {
            this.myRowIndexControl.setBaseLine(baseline -= this.myRowIndexControl.getBounds().y);
        }
        if (UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula() || UIUtil.isUnderNativeMacLookAndFeel()) {
            g.setColor(this.getBackground());
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
        super.paintComponent(g);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ArrangementGroupingComponent arrangementGroupingComponent = this;
        if (arrangementGroupingComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingComponent", "getComponent"));
        }
        return arrangementGroupingComponent;
    }

    public boolean isSelected() {
        return this.myGroupingTypeToken.isSelected();
    }

    public void setSelected(boolean selected) {
        this.myGroupingTypeToken.setSelected(selected);
        this.refreshControl();
    }

    private void refreshControl() {
        boolean checked = this.isSelected();
        if (this.myOrderTypeToken != null) {
            this.myOrderTypeToken.setEnabled(checked);
        }
    }

    @NotNull
    public ArrangementSettingsToken getGroupingType() {
        ArrangementSettingsToken token = this.myGroupingTypeToken.getToken();
        assert (token != null);
        ArrangementSettingsToken arrangementSettingsToken = token;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingComponent", "getGroupingType"));
        }
        return arrangementSettingsToken;
    }

    public void setOrderType(@NotNull ArrangementSettingsToken type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingComponent", "setOrderType"));
        }
        if (this.myOrderTypeToken != null) {
            this.myOrderTypeToken.chooseToken(type);
        }
    }

    public void setRowIndex(int row) {
        this.myRowIndexControl.setIndex(row);
    }

    public void setHighlight(boolean highlight) {
        this.setBackground(highlight ? UIUtil.getDecoratedRowColor() : UIUtil.getListBackground());
    }

    @Nullable
    public ArrangementSettingsToken getOrderType() {
        return this.myOrderTypeToken == null ? null : this.myOrderTypeToken.getToken();
    }

    @Override
    public String toString() {
        return this.myGroupingTypeToken.toString();
    }
}

