/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultilanguageCodeStyleAbstractPanel
extends CodeStyleAbstractPanel
implements CodeStyleSettingsCustomizable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel");
    private Language myLanguage;
    private int myLangSelectionIndex;
    private JTabbedPane tabbedPane;

    protected MultilanguageCodeStyleAbstractPanel(CodeStyleSettings settings) {
        super(settings);
    }

    protected void init() {
        this.customizeSettings();
    }

    protected void customizeSettings() {
        for (LanguageCodeStyleSettingsProvider provider : (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions((ExtensionPointName)LanguageCodeStyleSettingsProvider.EP_NAME)) {
            if (!provider.usesSharedPreview()) continue;
            this.resetDefaultNames();
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPanelLanguage(Language language) {
        boolean languageProviderFound = false;
        for (LanguageCodeStyleSettingsProvider provider : (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions((ExtensionPointName)LanguageCodeStyleSettingsProvider.EP_NAME)) {
            if (!provider.getLanguage().is(language)) continue;
            this.resetDefaultNames();
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
            languageProviderFound = true;
            break;
        }
        if (!languageProviderFound) {
            return false;
        }
        this.myLanguage = language;
        this.setSkipPreviewHighlighting(true);
        try {
            this.onLanguageChange(language);
        }
        finally {
            this.setSkipPreviewHighlighting(false);
        }
        this.updatePreview(true);
        return true;
    }

    public Language getSelectedLanguage() {
        return this.myLanguage;
    }

    public abstract LanguageCodeStyleSettingsProvider.SettingsType getSettingsType();

    protected void onLanguageChange(Language language) {
    }

    protected void resetDefaultNames() {
    }

    @Override
    protected String getPreviewText() {
        if (this.myLanguage == null) {
            return "";
        }
        String sample = LanguageCodeStyleSettingsProvider.getCodeSample((Language)this.myLanguage, (LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType());
        if (sample == null) {
            return "";
        }
        return sample;
    }

    @Override
    protected PsiFile createFileFromText(Project project, String text) {
        PsiFile file = LanguageCodeStyleSettingsProvider.createFileFromText((Language)this.myLanguage, (Project)project, (String)text);
        return file != null ? file : super.createFileFromText(project, text);
    }

    @Override
    protected int getRightMargin() {
        if (this.myLanguage == null) {
            return -1;
        }
        return LanguageCodeStyleSettingsProvider.getRightMargin((Language)this.myLanguage, (LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType());
    }

    @Override
    protected String getFileExt() {
        String fileExt = LanguageCodeStyleSettingsProvider.getFileExt((Language)this.myLanguage);
        if (fileExt != null) {
            return fileExt;
        }
        return super.getFileExt();
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType assocType;
        if (this.myLanguage != null && (assocType = this.myLanguage.getAssociatedFileType()) != null) {
            LanguageFileType languageFileType = assocType;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/MultilanguageCodeStyleAbstractPanel", "getFileType"));
            }
            return languageFileType;
        }
        Language[] langs = LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
        if (langs.length > 0) {
            this.myLanguage = langs[0];
            LanguageFileType type = langs[0].getAssociatedFileType();
            if (type != null) {
                LanguageFileType languageFileType = type;
                if (languageFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/MultilanguageCodeStyleAbstractPanel", "getFileType"));
                }
                return languageFileType;
            }
        }
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/MultilanguageCodeStyleAbstractPanel", "getFileType"));
        }
        return languageFileType;
    }

    @Override
    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        FileType fileType = this.getFileType();
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(ProjectUtil.guessCurrentProject((JComponent)this.getPanel()), fileType, null, scheme);
    }

    @Override
    protected PsiFile doReformat(final Project project, final PsiFile psiFile) {
        final String text = psiFile.getText();
        final PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        final Document doc = manager.getDocument(psiFile);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        doc.replaceString(0, doc.getTextLength(), (CharSequence)text);
                        manager.commitDocument(doc);
                        try {
                            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, "", (Object)"");
        if (doc != null) {
            manager.commitDocument(doc);
        }
        return psiFile;
    }

    protected static JPanel createPreviewPanel() {
        return new JPanel(new BorderLayout());
    }

    @Override
    protected void installPreviewPanel(JPanel previewPanel) {
        if (this.getSettingsType() != LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC) {
            this.tabbedPane = new JBTabbedPane();
            this.tabbedPane.setTabLayoutPolicy(1);
            Language[] langs = LanguageCodeStyleSettingsProvider.getLanguagesWithSharedPreview();
            if (langs.length == 0) {
                return;
            }
            for (Language lang : langs) {
                this.tabbedPane.addTab(MultilanguageCodeStyleAbstractPanel.getTabName(lang), MultilanguageCodeStyleAbstractPanel.createDummy());
            }
            this.tabbedPane.setComponentAt(0, this.getEditor().getComponent());
            this.myLangSelectionIndex = 0;
            if (this.myLanguage == null) {
                this.setPanelLanguage(langs[0]);
            } else {
                this.updatePreview(true);
            }
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MultilanguageCodeStyleAbstractPanel.this.onTabSelection((JTabbedPane)e.getSource());
                }
            });
            previewPanel.add((Component)this.tabbedPane, "Center");
            previewPanel.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

                public void ancestorAdded(AncestorEvent event) {
                    MultilanguageCodeStyleAbstractPanel.this.selectCurrentLanguageTab();
                }
            });
        } else {
            previewPanel.add((Component)this.getEditor().getComponent(), "Center");
            this.updatePreview(true);
        }
    }

    private void selectCurrentLanguageTab() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!MultilanguageCodeStyleAbstractPanel.getTabName(this.myLanguage).equals(this.tabbedPane.getTitleAt(i))) continue;
            this.tabbedPane.setSelectedIndex(i);
            return;
        }
    }

    private void onTabSelection(JTabbedPane tabs) {
        int i = tabs.getSelectedIndex();
        tabs.setComponentAt(this.myLangSelectionIndex, MultilanguageCodeStyleAbstractPanel.createDummy());
        tabs.setComponentAt(i, this.getEditor().getComponent());
        this.myLangSelectionIndex = i;
        String selectionTitle = tabs.getTitleAt(i);
        Language lang = LanguageCodeStyleSettingsProvider.getLanguage((String)selectionTitle);
        if (lang != null && this.getLanguageSelector() != null) {
            this.getLanguageSelector().setLanguage(lang);
        }
    }

    private static JComponent createDummy() {
        return new JLabel("");
    }

    private static String getTabName(Language language) {
        String tabName = LanguageCodeStyleSettingsProvider.getLanguageName((Language)language);
        if (tabName == null) {
            tabName = language.getDisplayName();
        }
        return tabName;
    }

    @Override
    public Language getDefaultLanguage() {
        return this.getSelectedLanguage();
    }

    public void moveStandardOption(String fieldName, String newGroup) {
        throw new UnsupportedOperationException();
    }

    protected <T extends OrderedOption> List<T> sortOptions(Collection<T> options) {
        THashSet names = new THashSet((Collection)ContainerUtil.map(options, (Function)new Function<OrderedOption, String>(){

            public String fun(OrderedOption option) {
                return option.getOptionName();
            }
        }));
        ArrayList<OrderedOption> order = new ArrayList<OrderedOption>(options.size());
        MultiMap afters = new MultiMap();
        MultiMap befores = new MultiMap();
        for (OrderedOption each : options) {
            String anchorOptionName = each.getAnchorOptionName();
            if (anchorOptionName != null && names.contains(anchorOptionName)) {
                if (each.getAnchor() == CodeStyleSettingsCustomizable.OptionAnchor.AFTER) {
                    afters.putValue((Object)anchorOptionName, (Object)each);
                    continue;
                }
                if (each.getAnchor() == CodeStyleSettingsCustomizable.OptionAnchor.BEFORE) {
                    befores.putValue((Object)anchorOptionName, (Object)each);
                    continue;
                }
            }
            order.add(each);
        }
        ArrayList<OrderedOption> result = new ArrayList<OrderedOption>(options.size());
        for (OrderedOption each : order) {
            result.addAll(befores.get((Object)each.getOptionName()));
            result.add(each);
            result.addAll(afters.get((Object)each.getOptionName()));
        }
        assert (result.size() == options.size());
        return result;
    }

    protected static abstract class OrderedOption {
        @NotNull
        private final String optionName;
        @Nullable
        private final CodeStyleSettingsCustomizable.OptionAnchor anchor;
        @Nullable
        private final String anchorOptionName;

        protected OrderedOption(@NotNull String optionName, CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorOptionName) {
            if (optionName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/MultilanguageCodeStyleAbstractPanel$OrderedOption", "<init>"));
            }
            this.optionName = optionName;
            this.anchor = anchor;
            this.anchorOptionName = anchorOptionName;
        }

        @NotNull
        public String getOptionName() {
            String string = this.optionName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/MultilanguageCodeStyleAbstractPanel$OrderedOption", "getOptionName"));
            }
            return string;
        }

        @Nullable
        public CodeStyleSettingsCustomizable.OptionAnchor getAnchor() {
            return this.anchor;
        }

        @Nullable
        public String getAnchorOptionName() {
            return this.anchorOptionName;
        }
    }
}

