/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMacrosCollector
extends PathMacroMap {
    public static final ExtensionPointName<PathMacroFilter> MACRO_FILTER_EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.pathMacroFilter");
    public static final Pattern MACRO_PATTERN = Pattern.compile("\\$([\\w\\-\\.]+?)\\$");
    private final Matcher myMatcher;
    private final Map<String, String> myMacroMap = ContainerUtilRt.newLinkedHashMap();

    private PathMacrosCollector() {
        this.myMatcher = MACRO_PATTERN.matcher("");
    }

    @NotNull
    public static Set<String> getMacroNames(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/PathMacrosCollector", "getMacroNames"));
        }
        Set<String> set = PathMacrosCollector.getMacroNames(e, new CompositePathMacroFilter((PathMacroFilter[])Extensions.getExtensions(MACRO_FILTER_EXTENSION_POINT_NAME)), PathMacros.getInstance());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/PathMacrosCollector", "getMacroNames"));
        }
        return set;
    }

    public static Set<String> getMacroNames(Element root, @Nullable PathMacroFilter filter, @NotNull PathMacros pathMacros) {
        if (pathMacros == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/application/options/PathMacrosCollector", "getMacroNames"));
        }
        PathMacrosCollector collector = new PathMacrosCollector();
        collector.substitute(root, true, false, filter);
        THashSet result = new THashSet(collector.myMacroMap.keySet());
        result.removeAll(pathMacros.getSystemMacroNames());
        result.removeAll(pathMacros.getLegacyMacroNames());
        result.removeAll(PathMacrosImpl.getToolMacroNames());
        result.removeAll(pathMacros.getIgnoredMacroNames());
        return result;
    }

    @Override
    public String substituteRecursively(String text, boolean caseSensitive) {
        if (StringUtil.isEmpty((String)text)) {
            return text;
        }
        this.myMatcher.reset(text);
        while (this.myMatcher.find()) {
            this.myMacroMap.put(this.myMatcher.group(1), null);
        }
        return text;
    }

    @Override
    public String substitute(String text, boolean caseSensitive) {
        if (StringUtil.isEmpty((String)text)) {
            return text;
        }
        int startPos = -1;
        if (text.charAt(0) == '$') {
            startPos = 0;
        } else {
            for (String protocol : ReplacePathToMacroMap.PROTOCOLS) {
                if (text.length() <= protocol.length() + 4 || !text.startsWith(protocol) || text.charAt(protocol.length()) != ':') continue;
                startPos = protocol.length() + 1;
                if (text.charAt(startPos) == '/') {
                    ++startPos;
                }
                if (text.charAt(startPos) != '/') continue;
                ++startPos;
            }
        }
        if (startPos < 0) {
            return text;
        }
        this.myMatcher.reset(text).region(startPos, text.length());
        if (this.myMatcher.lookingAt()) {
            this.myMacroMap.put(this.myMatcher.group(1), null);
        }
        return text;
    }

    @Override
    public int hashCode() {
        return ((Object)this.myMacroMap).hashCode();
    }
}

