/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCodeStylePanel
extends CodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.GeneralCodeStylePanel");
    private static final String SYSTEM_DEPENDANT_STRING = ApplicationBundle.message((String)"combobox.crlf.system.dependent", (Object[])new Object[0]);
    private static final String UNIX_STRING = ApplicationBundle.message((String)"combobox.crlf.unix", (Object[])new Object[0]);
    private static final String WINDOWS_STRING = ApplicationBundle.message((String)"combobox.crlf.windows", (Object[])new Object[0]);
    private static final String MACINTOSH_STRING = ApplicationBundle.message((String)"combobox.crlf.mac", (Object[])new Object[0]);
    private JSpinner myRightMarginSpinner;
    private JComboBox myLineSeparatorCombo;
    private JPanel myPanel;
    private JCheckBox myCbWrapWhenTypingReachesRightMargin;
    private JPanel myDefaultIndentOptionsPanel;
    private JCheckBox myEnableFormatterTags;
    private JTextField myFormatterOnTagField;
    private JTextField myFormatterOffTagField;
    private JCheckBox myAcceptRegularExpressionsCheckBox;
    private JPanel myMarkersPanel;
    private JBLabel myFormatterOffLabel;
    private JBLabel myFormatterOnLabel;
    private JPanel myMarkerOptionsPanel;
    private final SmartIndentOptionsEditor myIndentOptionsEditor;

    public GeneralCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        List<Object> indentOptionsProviders = Arrays.asList(Extensions.getExtensions((ExtensionPointName)FileTypeIndentOptionsProvider.EP_NAME));
        Collections.sort(indentOptionsProviders, new Comparator<FileTypeIndentOptionsProvider>(){

            @Override
            public int compare(FileTypeIndentOptionsProvider p1, FileTypeIndentOptionsProvider p2) {
                DisplayPriority priority2;
                Language lang1 = GeneralCodeStylePanel.getLanguage(p1.getFileType());
                if (lang1 == null) {
                    return -1;
                }
                Language lang2 = GeneralCodeStylePanel.getLanguage(p2.getFileType());
                if (lang2 == null) {
                    return 1;
                }
                DisplayPriority priority1 = LanguageCodeStyleSettingsProvider.getDisplayPriority((Language)lang1);
                if (priority1.equals((Object)(priority2 = LanguageCodeStyleSettingsProvider.getDisplayPriority((Language)lang2)))) {
                    return lang1.getDisplayName().compareTo(lang2.getDisplayName());
                }
                return priority1.compareTo((Enum)priority2);
            }
        });
        this.myLineSeparatorCombo.addItem(SYSTEM_DEPENDANT_STRING);
        this.myLineSeparatorCombo.addItem(UNIX_STRING);
        this.myLineSeparatorCombo.addItem(WINDOWS_STRING);
        this.myLineSeparatorCombo.addItem(MACINTOSH_STRING);
        this.addPanelToWatch(this.myPanel);
        this.myRightMarginSpinner.setModel(new SpinnerNumberModel(settings.RIGHT_MARGIN, 1, 1000000, 1));
        this.myIndentOptionsEditor = new SmartIndentOptionsEditor();
        this.myDefaultIndentOptionsPanel.add((Component)this.myIndentOptionsEditor.createPanel(), "Center");
        this.myEnableFormatterTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean tagsEnabled = GeneralCodeStylePanel.this.myEnableFormatterTags.isSelected();
                GeneralCodeStylePanel.this.setFormatterTagControlsEnabled(tagsEnabled);
            }
        });
        this.myMarkersPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.title", (Object[])new Object[0]), (boolean)true));
        this.myMarkerOptionsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.options.title", (Object[])new Object[0]), (boolean)true));
    }

    @Nullable
    private static Language getLanguage(FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Override
    protected void somethingChanged() {
        super.somethingChanged();
    }

    @Override
    protected int getRightMargin() {
        return ((Number)this.myRightMarginSpinner.getValue()).intValue();
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/GeneralCodeStylePanel", "getFileType"));
        }
        return languageFileType;
    }

    @Override
    protected String getPreviewText() {
        return "";
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        settings.LINE_SEPARATOR = this.getSelectedLineSeparator();
        settings.RIGHT_MARGIN = ((Number)this.myRightMarginSpinner.getValue()).intValue();
        settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = this.myCbWrapWhenTypingReachesRightMargin.isSelected();
        this.myIndentOptionsEditor.setEnabled(true);
        this.myIndentOptionsEditor.apply(settings, settings.OTHER_INDENT_OPTIONS);
        settings.FORMATTER_TAGS_ENABLED = this.myEnableFormatterTags.isSelected();
        settings.FORMATTER_TAGS_ACCEPT_REGEXP = this.myAcceptRegularExpressionsCheckBox.isSelected();
        settings.FORMATTER_OFF_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG);
        settings.setFormatterOffPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG));
        settings.FORMATTER_ON_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOnTagField, settings.FORMATTER_ON_TAG);
        settings.setFormatterOnPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOnTagField, settings.FORMATTER_ON_TAG));
    }

    @Nullable
    private static Pattern compilePattern(CodeStyleSettings settings, JTextField field, String patternText) {
        try {
            return Pattern.compile(patternText);
        }
        catch (PatternSyntaxException pse) {
            settings.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            GeneralCodeStylePanel.showError(field, ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.invalid.regexp", (Object[])new Object[0]));
            return null;
        }
    }

    private static String getTagText(JTextField field, String defualtValue) {
        String fieldText = field.getText();
        if (StringUtil.isEmpty((String)field.getText())) {
            field.setText(defualtValue);
            return defualtValue;
        }
        return fieldText;
    }

    @Nullable
    private String getSelectedLineSeparator() {
        if (UNIX_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\n";
        }
        if (MACINTOSH_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r";
        }
        if (WINDOWS_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r\n";
        }
        return null;
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        if (!Comparing.equal((String)this.getSelectedLineSeparator(), (String)settings.LINE_SEPARATOR)) {
            return true;
        }
        if (settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN ^ this.myCbWrapWhenTypingReachesRightMargin.isSelected()) {
            return true;
        }
        if (!Comparing.equal((Object)this.myRightMarginSpinner.getValue(), (Object)settings.RIGHT_MARGIN)) {
            return true;
        }
        this.myIndentOptionsEditor.setEnabled(true);
        if (this.myEnableFormatterTags.isSelected() ? !settings.FORMATTER_TAGS_ENABLED || settings.FORMATTER_TAGS_ACCEPT_REGEXP != this.myAcceptRegularExpressionsCheckBox.isSelected() || !StringUtil.equals((CharSequence)this.myFormatterOffTagField.getText(), (CharSequence)settings.FORMATTER_OFF_TAG) || !StringUtil.equals((CharSequence)this.myFormatterOnTagField.getText(), (CharSequence)settings.FORMATTER_ON_TAG) : settings.FORMATTER_TAGS_ENABLED) {
            return true;
        }
        return this.myIndentOptionsEditor.isModified(settings, settings.OTHER_INDENT_OPTIONS);
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        String lineSeparator = settings.LINE_SEPARATOR;
        if ("\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(UNIX_STRING);
        } else if ("\r\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(WINDOWS_STRING);
        } else if ("\r".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(MACINTOSH_STRING);
        } else {
            this.myLineSeparatorCombo.setSelectedItem(SYSTEM_DEPENDANT_STRING);
        }
        this.myRightMarginSpinner.setValue(settings.RIGHT_MARGIN);
        this.myCbWrapWhenTypingReachesRightMargin.setSelected(settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN);
        this.myIndentOptionsEditor.reset(settings, settings.OTHER_INDENT_OPTIONS);
        this.myIndentOptionsEditor.setEnabled(true);
        this.myAcceptRegularExpressionsCheckBox.setSelected(settings.FORMATTER_TAGS_ACCEPT_REGEXP);
        this.myEnableFormatterTags.setSelected(settings.FORMATTER_TAGS_ENABLED);
        this.myFormatterOnTagField.setText(settings.FORMATTER_ON_TAG);
        this.myFormatterOffTagField.setText(settings.FORMATTER_OFF_TAG);
        this.setFormatterTagControlsEnabled(settings.FORMATTER_TAGS_ENABLED);
    }

    private void setFormatterTagControlsEnabled(boolean isEnabled) {
        this.myFormatterOffTagField.setEnabled(isEnabled);
        this.myFormatterOnTagField.setEnabled(isEnabled);
        this.myMarkersPanel.setEnabled(isEnabled);
        this.myAcceptRegularExpressionsCheckBox.setEnabled(isEnabled);
        this.myFormatterOffLabel.setEnabled(isEnabled);
        this.myFormatterOnLabel.setEnabled(isEnabled);
        this.myMarkerOptionsPanel.setEnabled(isEnabled);
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme, null);
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
    }

    @Override
    public Language getDefaultLanguage() {
        return null;
    }

    private static void showError(JTextField field, String message) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR.getDefaultIcon(), MessageType.ERROR.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(1500L);
        Balloon balloon = balloonBuilder.createBalloon();
        Rectangle rect = field.getBounds();
        Point p = new Point(0, rect.height);
        RelativePoint point = new RelativePoint((Component)field, p);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)ProjectManager.getInstance().getDefaultProject(), (Disposable)balloon);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JTextField jTextField;
        JTextField jTextField2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        JCheckBox jCheckBox3;
        JSpinner jSpinner;
        JComboBox jComboBox;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "West");
        this.myLineSeparatorCombo = jComboBox = new JComboBox();
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.right.margin.columns"));
        jPanel5.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRightMarginSpinner = jSpinner = new JSpinner();
        jPanel5.add((Component)jSpinner, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, new Dimension(100, -1)));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.line.separator.for.new.files"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbWrapWhenTypingReachesRightMargin = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.wrap.typing.on.right.margin"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDefaultIndentOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Default Indent Options", (int)0, (int)0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.control"), (int)0, (int)0, null, null));
        this.myEnableFormatterTags = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.enable.formatter.tags"));
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMarkersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Markers:", 0, 0, null, null));
        this.myFormatterOffLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.off.tag"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFormatterOnLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.on.tag"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFormatterOnTagField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFormatterOffTagField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMarkerOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Font font = jPanel.getFont();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, new Font(font.getName(), font.getStyle(), font.getSize()), null));
        this.myAcceptRegularExpressionsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.marker.regexp"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, "Center");
        jLabel.setLabelFor(jSpinner);
        jLabel2.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jTextField);
        jBLabel.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

