/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ImportLayoutPanel;
import com.intellij.application.options.PackagePanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;

public class CodeStyleImportsPanel
extends JPanel {
    private JCheckBox myCbUseFQClassNames;
    private JCheckBox myCbUseFQClassNamesInJavaDoc;
    private JCheckBox myCbUseSingleClassImports;
    private JCheckBox myCbInsertInnerClassImports;
    private JTextField myClassCountField;
    private JTextField myNamesCountField;
    private final PackageEntryTable myPackageList;
    private JBTable myPackageTable;
    private final CodeStyleSettings mySettings;
    private JRadioButton myJspImportCommaSeparated;
    private JRadioButton myJspOneImportPerDirective;
    private JPanel myGeneralPanel;
    private JPanel myJSPPanel;
    private JPanel myPackagesPanel;
    private JPanel myImportsLayoutPanel;
    private JPanel myWholePanel;
    private ImportLayoutPanel myImportLayoutPanel;

    public CodeStyleImportsPanel(CodeStyleSettings settings) {
        this.$$$setupUI$$$();
        this.myPackageList = new PackageEntryTable();
        this.mySettings = settings;
        this.setLayout(new BorderLayout());
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
        this.add((Component)this.myWholePanel, "Center");
        this.myGeneralPanel.add((Component)this.createGeneralOptionsPanel(), "Center");
        this.myJSPPanel.add((Component)this.createJspImportLayoutPanel(), "Center");
        this.createImportPanel();
        this.createPackagePanel();
    }

    private void createImportPanel() {
        this.myImportLayoutPanel = new ImportLayoutPanel(){

            @Override
            public void refresh() {
                CodeStyleImportsPanel.this.refreshTable(CodeStyleImportsPanel.this.myPackageTable, CodeStyleImportsPanel.this.myPackageList);
                CodeStyleImportsPanel.this.refreshTable(this.getImportLayoutTable(), this.getImportLayoutList());
            }
        };
        this.myImportsLayoutPanel.add((Component)this.myImportLayoutPanel, "Center");
    }

    private void createPackagePanel() {
        this.myPackageTable = ImportLayoutPanel.createTableForPackageEntries(this.myPackageList, this.myImportLayoutPanel);
        this.myPackagesPanel.add((Component)PackagePanel.createPackagesPanel(this.myPackageTable, this.myPackageList), "Center");
    }

    private JPanel createJspImportLayoutPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.myJspImportCommaSeparated = new JRadioButton(ApplicationBundle.message((String)"radio.prefer.comma.separated.import.list", (Object[])new Object[0]));
        this.myJspOneImportPerDirective = new JRadioButton(ApplicationBundle.message((String)"radio.prefer.one.import.statement.per.page.directive", (Object[])new Object[0]));
        buttonGroup.add(this.myJspImportCommaSeparated);
        buttonGroup.add(this.myJspOneImportPerDirective);
        JPanel btnPanel = new JPanel(new BorderLayout());
        btnPanel.add((Component)this.myJspImportCommaSeparated, "North");
        btnPanel.add((Component)this.myJspOneImportPerDirective, "Center");
        final MultiLineLabel commaSeparatedLabel = new MultiLineLabel("<% page import=\"com.company.Boo, \n                 com.company.Far\"%>");
        final MultiLineLabel oneImportPerDirectiveLabel = new MultiLineLabel("<% page import=\"com.company.Boo\"%>\n<% page import=\"com.company.Far\"%>");
        final JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 10, 0, 0), (Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.preview", (Object[])new Object[0]), (boolean)false)));
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.add((Component)btnPanel, "North");
        resultPanel.add((Component)labelPanel, "Center");
        resultPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.jsp.imports.layout", (Object[])new Object[0]), (boolean)true));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isComma = CodeStyleImportsPanel.this.myJspImportCommaSeparated.isSelected();
                labelPanel.removeAll();
                labelPanel.add((Component)(isComma ? commaSeparatedLabel : oneImportPerDirectiveLabel), "North");
                labelPanel.repaint();
                labelPanel.revalidate();
            }
        };
        this.myJspImportCommaSeparated.addActionListener(actionListener);
        this.myJspOneImportPerDirective.addActionListener(actionListener);
        return resultPanel;
    }

    private JPanel createGeneralOptionsPanel() {
        OptionGroup group = new OptionGroup(ApplicationBundle.message((String)"title.general", (Object[])new Object[0]));
        this.myCbUseSingleClassImports = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.single.class.import", (Object[])new Object[0]));
        group.add((JComponent)this.myCbUseSingleClassImports);
        this.myCbUseFQClassNames = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.fully.qualified.class.names", (Object[])new Object[0]));
        group.add((JComponent)this.myCbUseFQClassNames);
        this.myCbInsertInnerClassImports = new JCheckBox(ApplicationBundle.message((String)"checkbox.insert.imports.for.inner.classes", (Object[])new Object[0]));
        group.add((JComponent)this.myCbInsertInnerClassImports);
        this.myCbUseFQClassNamesInJavaDoc = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.fully.qualified.class.names.in.javadoc", (Object[])new Object[0]));
        group.add((JComponent)this.myCbUseFQClassNamesInJavaDoc);
        this.myClassCountField = new JTextField(3);
        this.myNamesCountField = new JTextField(3);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.class.count.to.use.import.with.star", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.myClassCountField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 1, 0, 0), 0, 0));
        panel.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.names.count.to.use.static.import.with.star", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.myNamesCountField, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 1, 0, 0), 0, 0));
        group.add((JComponent)panel);
        return group.createPanel();
    }

    private void refreshTable(JBTable table, PackageEntryTable packageTable) {
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        table.createDefaultColumnsFromModel();
        model.fireTableDataChanged();
        ImportLayoutPanel.resizeColumns(packageTable, table, this.myImportLayoutPanel.areStaticImportsEnabled());
    }

    public void reset(CodeStyleSettings settings) {
        this.myCbUseFQClassNames.setSelected(settings.USE_FQ_CLASS_NAMES);
        this.myCbUseFQClassNamesInJavaDoc.setSelected(settings.USE_FQ_CLASS_NAMES_IN_JAVADOC);
        this.myCbUseSingleClassImports.setSelected(settings.USE_SINGLE_CLASS_IMPORTS);
        this.myCbInsertInnerClassImports.setSelected(settings.INSERT_INNER_CLASS_IMPORTS);
        this.myClassCountField.setText(Integer.toString(settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND));
        this.myNamesCountField.setText(Integer.toString(settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND));
        this.myImportLayoutPanel.getImportLayoutList().copyFrom(settings.IMPORT_LAYOUT_TABLE);
        this.myPackageList.copyFrom(settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        this.myImportLayoutPanel.getCbLayoutStaticImportsSeparately().setSelected(settings.LAYOUT_STATIC_IMPORTS_SEPARATELY);
        JBTable importLayoutTable = this.myImportLayoutPanel.getImportLayoutTable();
        AbstractTableModel model = (AbstractTableModel)importLayoutTable.getModel();
        model.fireTableDataChanged();
        model = (AbstractTableModel)this.myPackageTable.getModel();
        model.fireTableDataChanged();
        if (importLayoutTable.getRowCount() > 0) {
            importLayoutTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.myPackageTable.getRowCount() > 0) {
            this.myPackageTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (settings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST) {
            this.myJspImportCommaSeparated.doClick();
        } else {
            this.myJspOneImportPerDirective.doClick();
        }
    }

    public void reset() {
        this.reset(this.mySettings);
    }

    public void apply(CodeStyleSettings settings) {
        this.stopTableEditing();
        settings.LAYOUT_STATIC_IMPORTS_SEPARATELY = this.myImportLayoutPanel.areStaticImportsEnabled();
        settings.USE_FQ_CLASS_NAMES = this.myCbUseFQClassNames.isSelected();
        settings.USE_FQ_CLASS_NAMES_IN_JAVADOC = this.myCbUseFQClassNamesInJavaDoc.isSelected();
        settings.USE_SINGLE_CLASS_IMPORTS = this.myCbUseSingleClassImports.isSelected();
        settings.INSERT_INNER_CLASS_IMPORTS = this.myCbInsertInnerClassImports.isSelected();
        try {
            settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = Integer.parseInt(this.myClassCountField.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = Integer.parseInt(this.myNamesCountField.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        PackageEntryTable list = this.myImportLayoutPanel.getImportLayoutList();
        list.removeEmptyPackages();
        settings.IMPORT_LAYOUT_TABLE.copyFrom(list);
        this.myPackageList.removeEmptyPackages();
        settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(this.myPackageList);
        settings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST = this.myJspImportCommaSeparated.isSelected();
    }

    public void apply() {
        this.apply(this.mySettings);
    }

    private void stopTableEditing() {
        TableUtil.stopEditing((JTable)this.myImportLayoutPanel.getImportLayoutTable());
        TableUtil.stopEditing((JTable)this.myPackageTable);
    }

    public boolean isModified(CodeStyleSettings settings) {
        boolean isModified = CodeStyleImportsPanel.isModified((JCheckBox)this.myImportLayoutPanel.getCbLayoutStaticImportsSeparately(), settings.LAYOUT_STATIC_IMPORTS_SEPARATELY);
        isModified |= CodeStyleImportsPanel.isModified(this.myCbUseFQClassNames, settings.USE_FQ_CLASS_NAMES);
        isModified |= CodeStyleImportsPanel.isModified(this.myCbUseFQClassNamesInJavaDoc, settings.USE_FQ_CLASS_NAMES_IN_JAVADOC);
        isModified |= CodeStyleImportsPanel.isModified(this.myCbUseSingleClassImports, settings.USE_SINGLE_CLASS_IMPORTS);
        isModified |= CodeStyleImportsPanel.isModified(this.myCbInsertInnerClassImports, settings.INSERT_INNER_CLASS_IMPORTS);
        isModified |= CodeStyleImportsPanel.isModified(this.myClassCountField, settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND);
        isModified |= CodeStyleImportsPanel.isModified(this.myNamesCountField, settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND);
        isModified |= CodeStyleImportsPanel.isModified(this.myImportLayoutPanel.getImportLayoutList(), settings.IMPORT_LAYOUT_TABLE);
        isModified |= CodeStyleImportsPanel.isModified(this.myPackageList, settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        return isModified |= settings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST != this.myJspImportCommaSeparated.isSelected();
    }

    public boolean isModified() {
        return this.isModified(this.mySettings);
    }

    private static boolean isModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(PackageEntryTable list, PackageEntryTable table) {
        if (list.getEntryCount() != table.getEntryCount()) {
            return true;
        }
        for (int i = 0; i < list.getEntryCount(); ++i) {
            PackageEntry entry2;
            PackageEntry entry1 = list.getEntryAt(i);
            if (entry1.equals((Object)(entry2 = table.getEntryAt(i)))) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myWholePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel6);
        this.myGeneralPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(-1, -1));
        jPanel6.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myJSPPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(-1, -1));
        jPanel6.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPackagesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(-1, -1));
        jPanel6.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myImportsLayoutPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        jPanel6.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

