/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseClassesAnalysisAction
extends BaseAnalysisAction {
    protected BaseClassesAnalysisAction(String title, String analysisNoon) {
        super(title, analysisNoon);
    }

    protected abstract void analyzeClasses(Project var1, AnalysisScope var2, ProgressIndicator var3);

    @Override
    protected void analyze(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/BaseClassesAnalysisAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/analysis/BaseClassesAnalysisAction", "analyze"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, AnalysisScopeBundle.message((String)"analyzing.project", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/BaseClassesAnalysisAction$1", "run"));
                }
                indicator.setIndeterminate(true);
                indicator.setText(AnalysisScopeBundle.message((String)"checking.class.files", (Object[])new Object[0]));
                CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                final boolean upToDate = compilerManager.isUpToDate(compilerManager.createProjectCompileScope(this.myProject));
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!upToDate) {
                            int i = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)AnalysisScopeBundle.message((String)"recompile.confirmation.message", (Object[])new Object[0]), (String)AnalysisScopeBundle.message((String)"project.is.out.of.date", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
                            if (i == 2) {
                                return;
                            }
                            if (i == 0) {
                                BaseClassesAnalysisAction.this.compileAndAnalyze(project, scope);
                            } else {
                                BaseClassesAnalysisAction.this.doAnalyze(project, scope);
                            }
                        } else {
                            BaseClassesAnalysisAction.this.doAnalyze(project, scope);
                        }
                    }
                });
            }
        });
    }

    private void doAnalyze(final Project project, final AnalysisScope scope) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, AnalysisScopeBundle.message((String)"analyzing.project", (Object[])new Object[0]), true){

            @Nullable
            public Task.NotificationInfo getNotificationInfo() {
                return new Task.NotificationInfo("Analysis", "\"" + this.getTitle() + "\" Analysis Finished", "");
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/analysis/BaseClassesAnalysisAction$2", "run"));
                }
                BaseClassesAnalysisAction.this.analyzeClasses(project, scope, indicator);
            }
        });
    }

    private void compileAndAnalyze(final Project project, final AnalysisScope scope) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        compilerManager.make(compilerManager.createProjectCompileScope(project), new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (aborted || errors != 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BaseClassesAnalysisAction.this.doAnalyze(project, scope);
                    }
                });
            }
        });
    }
}

