/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestClassesFilter;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GroupBasedTestClassFilter
extends TestClassesFilter {
    public static final String ALL_EXCLUDE_DEFINED = "ALL_EXCLUDE_DEFINED";
    private final Map<String, List<Pattern>> myPatterns = new HashMap<String, List<Pattern>>();
    private final List<Pattern> myAllPatterns = new ArrayList<Pattern>();
    private final List<Pattern> myTestGroupPatterns;
    private final String myTestGroupName;

    private GroupBasedTestClassFilter(Map<String, List<String>> filters, String testGroupName) {
        this.myTestGroupName = testGroupName;
        for (String groupName : filters.keySet()) {
            List<String> filterList = filters.get(groupName);
            this.addPatterns(groupName, filterList);
        }
        this.myTestGroupPatterns = this.collectPatternsFor(this.myTestGroupName);
    }

    private void addPatterns(String groupName, List<String> filterList) {
        ArrayList<Pattern> patterns = GroupBasedTestClassFilter.compilePatterns(filterList);
        this.myPatterns.put(groupName, patterns);
        this.myAllPatterns.addAll(patterns);
    }

    public static TestClassesFilter createOn(Reader reader, String testGroupName) throws IOException {
        String line;
        HashMap<String, List<String>> groupNameToPatternsMap = new HashMap<String, List<String>>();
        String currentGroupName = "";
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                currentGroupName = line.substring(1, line.length() - 1);
                continue;
            }
            if (!groupNameToPatternsMap.containsKey(currentGroupName)) {
                groupNameToPatternsMap.put(currentGroupName, new ArrayList());
            }
            ((List)groupNameToPatternsMap.get(currentGroupName)).add(line);
        }
        return new GroupBasedTestClassFilter(groupNameToPatternsMap, testGroupName);
    }

    @Override
    public boolean matches(String className) {
        boolean result = GroupBasedTestClassFilter.matchesAnyPattern(this.myTestGroupPatterns, className);
        if (GroupBasedTestClassFilter.isAllExcludeDefinedGroup(this.myTestGroupName)) {
            return !result;
        }
        return result;
    }

    private static boolean isAllExcludeDefinedGroup(String groupName) {
        return StringUtil.isEmpty((String)groupName) || ALL_EXCLUDE_DEFINED.equalsIgnoreCase(groupName.trim());
    }

    private List<Pattern> collectPatternsFor(String groupName) {
        if (GroupBasedTestClassFilter.isAllExcludeDefinedGroup(groupName)) {
            return this.myAllPatterns;
        }
        if (this.myPatterns.containsKey(groupName)) {
            return this.myPatterns.get(groupName);
        }
        return Collections.emptyList();
    }
}

